/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.DocxParagraphHelper;
import net.sf.jasperreports.engine.export.ooxml.DocxRunHelper;
import net.sf.jasperreports.engine.util.JRDataUtils;

public class DocxStyleHelper
extends BaseHelper {
    private DocxParagraphHelper paragraphHelper = null;
    private DocxRunHelper runHelper = null;

    public DocxStyleHelper(Writer writer, Map fontMap, String exporterKey) {
        super(writer);
        this.paragraphHelper = new DocxParagraphHelper(writer, false);
        this.runHelper = new DocxRunHelper(writer, fontMap, exporterKey);
    }

    public void export(List jasperPrintList) throws IOException {
        this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.writer.write("<w:styles\n");
        this.writer.write(" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\"\n");
        this.writer.write(" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\">\n");
        this.writer.write(" <w:docDefaults>\n");
        this.writer.write("  <w:rPrDefault>\n");
        this.writer.write("   <w:rPr>\n");
        this.writer.write("    <w:rFonts w:ascii=\"Times New Roman\" w:eastAsia=\"Times New Roman\" w:hAnsi=\"Times New Roman\" w:cs=\"Times New Roman\"/>\n");
        this.writer.write("   </w:rPr>\n");
        this.writer.write("  </w:rPrDefault>\n");
        this.writer.write("  <w:pPrDefault>\n");
        this.writer.write("  </w:pPrDefault>\n");
        this.writer.write(" </w:docDefaults>\n");
        for (int reportIndex = 0; reportIndex < jasperPrintList.size(); ++reportIndex) {
            JRStyle[] styles;
            JasperPrint jasperPrint = (JasperPrint)jasperPrintList.get(reportIndex);
            String localeCode = jasperPrint.getLocaleCode();
            if (reportIndex == 0) {
                JRDesignStyle style = new JRDesignStyle();
                style.setName("EMPTY_CELL_STYLE");
                style.setParentStyle(jasperPrint.getDefaultStyle());
                style.setFontSize(0);
                this.exportHeader(style);
                this.paragraphHelper.exportProps(style);
                this.runHelper.exportProps(style, localeCode == null ? null : JRDataUtils.getLocale(localeCode));
                this.exportFooter();
            }
            if ((styles = jasperPrint.getStyles()) == null) continue;
            for (int i = 0; i < styles.length; ++i) {
                JRStyle style = styles[i];
                this.exportHeader(style);
                this.paragraphHelper.exportProps(style);
                this.runHelper.exportProps(style, localeCode == null ? null : JRDataUtils.getLocale(localeCode));
                this.exportFooter();
            }
        }
        this.writer.write("</w:styles>\n");
    }

    private void exportHeader(JRStyle style) throws IOException {
        String styleNameReference;
        this.writer.write(" <w:style w:type=\"paragraph\" w:styleId=\"" + style.getName() + "\"");
        if (style.isDefault()) {
            this.writer.write(" w:default=\"1\"");
        }
        this.writer.write(">\n");
        this.writer.write("  <w:name w:val=\"" + style.getName() + "\" />\n");
        this.writer.write("  <w:qFormat />\n");
        String string = styleNameReference = style.getStyle() == null ? null : style.getStyle().getName();
        if (styleNameReference != null) {
            this.writer.write("  <w:basedOn w:val=\"" + styleNameReference + "\" />\n");
        }
    }

    private void exportFooter() throws IOException {
        this.writer.write(" </w:style>\n");
    }
}

