/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.treetable;

import exenne.components.treetable.RenderDataProvider;
import exenne.components.treetable.RowModel;
import exenne.components.treetable.SelfManagedComponent;
import exenne.components.treetable.TreePathSupport;
import exenne.components.treetable.TreetableModel;
import exenne.components.treetable.cellrenderers.AbstractTreetableCellRenderer;
import exenne.components.treetable.cellrenderers.DefaultTreetableCellRenderer;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.CellEditor;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class Treetable
extends JTable {
    private boolean initialized = false;
    private Boolean cachedRootVisible = null;
    private boolean needCalcRowHeight = true;
    private RenderDataProvider renderDataProvider = null;
    private ComponentListener componentListener = null;
    private AbstractTreetableCellRenderer cellRenderer;
    private PropertyChangeListener editorRemover = null;

    public Treetable(AbstractTreetableCellRenderer renderer) {
        this.cellRenderer = renderer;
        this.init(renderer);
    }

    public Treetable() {
        this(new DefaultTreetableCellRenderer());
    }

    private void init(DefaultTableCellRenderer renderer) {
        this.initialized = true;
        this.setDefaultRenderer(Object.class, renderer);
        this.setDefaultRenderer(BigDecimal.class, renderer);
        this.setDefaultRenderer(Integer.class, renderer);
    }

    public void resetPrefferedWidth() {
        TableColumnModel columns = this.getColumnModel();
        TreetableModel treetableModel = this.getTreetableModel();
        if (treetableModel == null) {
            return;
        }
        RowModel rowModel = treetableModel.getRowModel();
        if (rowModel == null) {
            return;
        }
        if (this.renderDataProvider == null) {
            return;
        }
        TableCellRenderer auxHeaderRenderer = null;
        CellEditor auxCellEditor = null;
        TableColumn column = columns.getColumn(0);
        auxHeaderRenderer = this.renderDataProvider.getColumnHeaderRenderer();
        if (auxHeaderRenderer != null) {
            column.setHeaderRenderer(auxHeaderRenderer);
        }
        column.setPreferredWidth(this.renderDataProvider.getColumnPrefferedWidth());
        for (int i = 0; i < rowModel.getColumnCount(); ++i) {
            column = columns.getColumn(i + 1);
            auxHeaderRenderer = rowModel.getColumnHeaderRenderer(i);
            if (auxHeaderRenderer != null) {
                column.setHeaderRenderer(auxHeaderRenderer);
            }
            if ((auxCellEditor = rowModel.getColumnCellEditor(i)) != null) {
                column.setCellEditor(this.cellEditor);
            }
            column.setPreferredWidth(rowModel.getColumnPrefferedWidth(i));
        }
    }

    public void setRowHeight(int val) {
        super.setRowHeight(val);
        if (this.getLayoutCache() != null) {
            this.getLayoutCache().setRowHeight(val);
        }
    }

    public void setRootVisible(boolean val) {
        if (this.getTreetableModel() == null) {
            Boolean bl = this.cachedRootVisible = val ? Boolean.TRUE : Boolean.FALSE;
        }
        if (val != this.isRootVisible()) {
            this.getLayoutCache().setRootVisible(val);
            this.firePropertyChange("rootVisible", !val, val);
        }
    }

    public void setRenderDataProvider(RenderDataProvider provider) {
        if (provider != this.renderDataProvider) {
            RenderDataProvider old = this.renderDataProvider;
            this.renderDataProvider = provider;
            this.firePropertyChange("renderDataProvider", old, provider);
        }
        this.resetPrefferedWidth();
    }

    public void setModel(TableModel mdl) {
        if (this.initialized && !(mdl instanceof TreetableModel)) {
            throw new IllegalArgumentException("Table model for an Outline must be an instance of OutlineModel");
        }
        if (mdl instanceof TreetableModel) {
            AbstractLayoutCache layout = ((TreetableModel)mdl).getLayout();
            if (this.cachedRootVisible != null) {
                layout.setRootVisible(this.cachedRootVisible);
            }
            layout.setRowHeight(this.getRowHeight());
            if (((TreetableModel)mdl).isLargeModel()) {
                this.addComponentListener(this.getComponentListener());
                layout.setNodeDimensions(new ND());
            } else if (this.componentListener != null) {
                this.removeComponentListener(this.componentListener);
                this.componentListener = null;
            }
        }
        super.setModel(mdl);
        this.resetPrefferedWidth();
    }

    public boolean isTreeColumnIndex(int column) {
        return column == 0;
    }

    public boolean isVisible(TreePath path) {
        if (this.getTreePathSupport() != null) {
            return this.getTreePathSupport().isVisible(path);
        }
        return false;
    }

    public boolean isRootVisible() {
        if (this.getLayoutCache() == null) {
            return this.cachedRootVisible != null ? this.cachedRootVisible : true;
        }
        return this.getLayoutCache().isRootVisible();
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer result = column == 0 ? this.getDefaultRenderer(Object.class) : super.getCellRenderer(row, column);
        return result;
    }

    public RenderDataProvider getRenderDataProvider() {
        return this.renderDataProvider;
    }

    public TreePathSupport getTreePathSupport() {
        TreetableModel mdl = this.getTreetableModel();
        if (mdl != null) {
            return mdl.getTreePathSupport();
        }
        return null;
    }

    public AbstractLayoutCache getLayoutCache() {
        TreetableModel mdl = this.getTreetableModel();
        if (mdl != null) {
            return mdl.getLayout();
        }
        return null;
    }

    public TreetableModel getTreetableModel() {
        TableModel mdl = this.getModel();
        if (mdl instanceof TreetableModel) {
            return (TreetableModel)this.getModel();
        }
        return null;
    }

    private ComponentListener getComponentListener() {
        if (this.componentListener == null) {
            this.componentListener = new SizeManager();
        }
        return this.componentListener;
    }

    private JScrollPane getScrollPane() {
        JScrollPane result = null;
        if (this.getParent() instanceof JViewport && ((JViewport)this.getParent()).getParent() instanceof JScrollPane) {
            result = (JScrollPane)((JViewport)this.getParent()).getParent();
        }
        return result;
    }

    private void calcRowHeight(Graphics g) {
        int localRowHeight;
        Integer i = (Integer)UIManager.get("netbeans.outline.rowHeight");
        if (i != null) {
            localRowHeight = i;
        } else {
            Font f = this.getFont();
            FontMetrics fm = g.getFontMetrics(f);
            localRowHeight = Math.max(fm.getHeight() + 3, this.cellRenderer.getExpansionHandleHeight());
        }
        this.needCalcRowHeight = false;
        this.setRowHeight(localRowHeight);
    }

    private void change() {
        this.revalidate();
        this.repaint();
    }

    private int[] toPrimitive(Integer[] irri) {
        int[] array = new int[irri.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = irri[i];
        }
        return array;
    }

    public DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.getValueAt(this.getSelectedRow(), 0);
    }

    public DefaultMutableTreeNode getNodeAt(int row) {
        return (DefaultMutableTreeNode)this.getValueAt(row, 0);
    }

    public int getRowForNode(DefaultMutableTreeNode node) {
        DefaultTreeModel localTreeModel = (DefaultTreeModel)this.getTreetableModel().getTreeModel();
        TreePath treePath = new TreePath(localTreeModel.getPathToRoot(node));
        return this.getLayoutCache().getRowForPath(treePath);
    }

    public void selectNode(DefaultMutableTreeNode node) {
        int row = this.getRowForNode(node);
        if (row != -1) {
            this.addRowSelectionInterval(row, row);
        }
    }

    public void selectAndScrollToNode(DefaultMutableTreeNode node) {
        int row = this.getRowForNode(node);
        if (row != -1) {
            this.addRowSelectionInterval(row, row);
            Rectangle rectangle = this.getCellRect(row, 0, true);
            this.scrollRectToVisible(rectangle);
        }
    }

    public int[] getSelectedIndices() {
        ListSelectionModel lsm = this.getSelectionModel();
        int min = lsm.getMinSelectionIndex();
        int max = lsm.getMaxSelectionIndex();
        ArrayList<Integer> al = new ArrayList<Integer>();
        for (int i = min; i <= max; ++i) {
            if (!lsm.isSelectedIndex(i)) continue;
            al.add(new Integer(i));
        }
        Integer[] ints = al.toArray(new Integer[0]);
        return this.toPrimitive(ints);
    }

    public void expandPath(TreePath path) {
        TreeNode treeNode;
        Object lastPathComponent = path.getLastPathComponent();
        if (lastPathComponent instanceof TreeNode && (treeNode = (TreeNode)lastPathComponent).getChildCount() == 0) {
            return;
        }
        if (!this.getTreePathSupport().isExpanded(path)) {
            this.getTreePathSupport().expandPath(path);
        }
    }

    public void collapsePath(TreePath path) {
        if (this.getTreePathSupport().isExpanded(path)) {
            this.getTreePathSupport().collapsePath(path);
        }
    }

    public Rectangle getPathBounds(TreePath path) {
        Insets i = this.getInsets();
        Rectangle bounds = this.getLayoutCache().getBounds(path, null);
        if (bounds != null && i != null) {
            bounds.x += i.left;
            bounds.y += i.top;
        }
        return bounds;
    }

    public TreePath getClosestPathForLocation(int x, int y) {
        Insets i = this.getInsets();
        if (i != null) {
            return this.getLayoutCache().getPathClosestTo(x - i.left, y - i.top);
        }
        return this.getLayoutCache().getPathClosestTo(x, y);
    }

    public void expandNode(DefaultMutableTreeNode node) {
        DefaultTreeModel localTreeModel = (DefaultTreeModel)this.getTreetableModel().getTreeModel();
        TreePath treePath = new TreePath(localTreeModel.getPathToRoot(node));
        this.expandPath(treePath);
    }

    public void collapseNode(DefaultMutableTreeNode node) {
        DefaultTreeModel localTreeModel = (DefaultTreeModel)this.getTreetableModel().getTreeModel();
        if (node.getChildCount() > 0) {
            TreePath treePath = new TreePath(localTreeModel.getPathToRoot(node));
            this.collapsePath(treePath);
        }
    }

    public boolean isNodeExpanded(DefaultMutableTreeNode node) {
        DefaultTreeModel localTreeModel = (DefaultTreeModel)this.getTreetableModel().getTreeModel();
        TreePath treePath = new TreePath(localTreeModel.getPathToRoot(node));
        return this.getTreePathSupport().isExpanded(treePath);
    }

    public boolean editCellAt(int row, int column, EventObject e) {
        TableCellEditor editor;
        if (this.isTreeColumnIndex(column) && e instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)e;
            TreePath path = this.getLayoutCache().getPathClosestTo(me.getX(), me.getY());
            if (path == null) {
                return false;
            }
            if (!this.getTreetableModel().isLeaf(path.getLastPathComponent())) {
                int handleWidth = this.cellRenderer.getExpansionHandleWidth();
                Insets ins = this.getInsets();
                int handleStart = path.getPathCount() == 1 ? ins.left : ins.left + (path.getPathCount() - 2) * this.cellRenderer.getNestingWidth();
                int handleEnd = ins.left + handleStart + handleWidth;
                if (me.getX() > ins.left && me.getX() >= handleStart && me.getX() <= handleEnd || me.getClickCount() > 1) {
                    boolean expanded = this.getLayoutCache().isExpanded(path);
                    if (!expanded) {
                        this.getTreePathSupport().expandPath(path);
                    } else {
                        this.getTreePathSupport().collapsePath(path);
                    }
                    return false;
                }
            }
        }
        if (this.cellEditor != null && !this.cellEditor.stopCellEditing()) {
            return false;
        }
        if (row < 0 || row >= this.getRowCount() || column < 0 || column >= this.getColumnCount()) {
            return false;
        }
        if (!this.isCellEditable(row, column)) {
            return false;
        }
        if (this.editorRemover == null) {
            KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.editorRemover = new CellEditorRemover(fm);
            fm.addPropertyChangeListener("permanentFocusOwner", this.editorRemover);
        }
        if ((editor = this.getCellEditor(row, column)) != null && editor.isCellEditable(e)) {
            this.editorComp = this.prepareEditor(editor, row, column);
            if (this.editorComp == null) {
                this.removeEditor();
                return false;
            }
            Rectangle cellRect = this.getCellRect(row, column, false);
            if (this.editorComp instanceof SelfManagedComponent) {
                ((SelfManagedComponent)((Object)this.editorComp)).updateBounds(cellRect);
            } else {
                this.editorComp.setBounds(cellRect);
            }
            this.add(this.editorComp);
            this.editorComp.validate();
            this.editorComp.repaint();
            this.setCellEditor(editor);
            this.setEditingRow(row);
            this.setEditingColumn(column);
            editor.addCellEditorListener(this);
            return true;
        }
        return false;
    }

    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
    }

    public void repaintRow(int tableRow) {
        TableModelEvent e = new TableModelEvent(this.getTreetableModel(), tableRow);
        super.tableChanged(e);
    }

    public void paint(Graphics g) {
        if (this.needCalcRowHeight) {
            this.calcRowHeight(g);
            return;
        }
        super.paint(g);
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return this.getParent().getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isEditing()) {
            Component component = this.getEditorComponent();
            component.repaint();
        }
    }

    public void removeEditor() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.editorRemover);
        this.editorRemover = null;
        TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            editor.removeCellEditorListener(this);
            Rectangle cellRect = this.getCellRect(this.editingRow, this.editingColumn, false);
            if (this.editorComp != null) {
                cellRect = cellRect.union(this.editorComp.getBounds());
                this.remove(this.editorComp);
            }
            this.setCellEditor(null);
            this.setEditingColumn(-1);
            this.setEditingRow(-1);
            this.editorComp = null;
            this.repaint(cellRect);
        }
    }

    public void removeNotify() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.editorRemover);
        this.editorRemover = null;
        super.removeNotify();
    }

    private class CellEditorRemover
    implements PropertyChangeListener {
        KeyboardFocusManager focusManager;

        public CellEditorRemover(KeyboardFocusManager fm) {
            this.focusManager = fm;
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if (!Treetable.this.isEditing() || Treetable.this.getClientProperty("terminateEditOnFocusLost") != Boolean.TRUE) {
                return;
            }
            for (Component c = this.focusManager.getPermanentFocusOwner(); c != null; c = c.getParent()) {
                if (c == Treetable.this) {
                    return;
                }
                if (!(c instanceof Window) && (!(c instanceof Applet) || c.getParent() != null)) continue;
                if (c != SwingUtilities.getRoot(Treetable.this) || Treetable.this.getCellEditor().stopCellEditing()) break;
                Treetable.this.getCellEditor().cancelCellEditing();
                break;
            }
        }
    }

    private class SizeManager
    extends ComponentAdapter
    implements ActionListener {
        protected Timer timer = null;
        protected JScrollBar scrollBar = null;

        private SizeManager() {
        }

        public void componentMoved(ComponentEvent e) {
            if (this.timer == null) {
                JScrollPane scrollPane = Treetable.this.getScrollPane();
                if (scrollPane == null) {
                    Treetable.this.change();
                } else {
                    this.scrollBar = scrollPane.getVerticalScrollBar();
                    if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                        this.scrollBar = scrollPane.getHorizontalScrollBar();
                        if (this.scrollBar != null && this.scrollBar.getValueIsAdjusting()) {
                            this.startTimer();
                        } else {
                            Treetable.this.change();
                        }
                    } else {
                        this.startTimer();
                    }
                }
            }
        }

        protected void startTimer() {
            if (this.timer == null) {
                this.timer = new Timer(200, this);
                this.timer.setRepeats(true);
            }
            this.timer.start();
        }

        public void actionPerformed(ActionEvent ae) {
            if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                if (this.timer != null) {
                    this.timer.stop();
                }
                Treetable.this.change();
                this.timer = null;
                this.scrollBar = null;
            }
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
        }

        public void componentShown(ComponentEvent e) {
        }
    }

    private class ND
    extends AbstractLayoutCache.NodeDimensions {
        private ND() {
        }

        public Rectangle getNodeDimensions(Object value, int row, int depth, boolean expanded, Rectangle bounds) {
            int wid = Treetable.this.getColumnModel().getColumn(0).getPreferredWidth();
            bounds.setBounds(0, row * Treetable.this.getRowHeight(), wid, Treetable.this.getRowHeight());
            return bounds;
        }
    }
}

