/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.treetable.test;

import exenne.components.headerrenderer.MultilineHeaderRenderer;
import exenne.components.transfer.PackObjects;
import exenne.components.treetable.DefaultTreetableModel;
import exenne.components.treetable.RenderDataProvider;
import exenne.components.treetable.RowModel;
import exenne.components.treetable.Treetable;
import exenne.components.treetable.TreetableListSelectionHandler;
import exenne.components.treetable.TreetableModel;
import exenne.components.treetable.cellrenderers.DefaultTreetableCellRenderer;
import exenne.components.treetable.dnd.TransferDataProvider;
import exenne.components.treetable.dnd.TreetableTransferHandler;
import exenne.components.treetable.test.ControllerNode;
import exenne.components.treetable.test.PackNode;
import exenne.components.treetable.undosupport.InsertNodeToParentStandardUndoableEdit;
import exenne.components.treetable.undosupport.RemoveNodeFromParentStandardUndoableEdit;
import exenne.components.treetable.warningrowbar.JWarningRowBar;
import exenne.components.treetable.warningrowbar.RunnableSuggestion;
import exenne.components.treetable.warningrowbar.WarningBarCellData;
import exenne.components.treetable.warningrowbar.WarningRowBarModel;
import exenne.components.utils.RandomDataGenerator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.CellEditor;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class TreetableTestClass
extends JPanel
implements ActionListener {
    private Treetable treetable;
    private TreeModel treeMdl;
    private TableModel tableMdl;
    private TableColumnModel columns;
    private NodeRowModel rowModel;
    private TreetableModel mdl;
    TreetableListSelectionHandler selectionHandler;
    MultilineHeaderRenderer multirenderer;
    private static final String ACTION_ADD = "add_node";
    private static final String ACTION_DELETE = "del_node";
    JToolBar toolBar;
    JButton buttonAdd;
    JButton buttonDelete;
    TransferDataProvider transferDataProvider = new TransferDataProvider(){

        public Treetable getTreetable() {
            return TreetableTestClass.this.treetable;
        }

        public int getSourceActions() {
            return 3;
        }

        public String getFlavourName() {
            return "PcakControllerNode";
        }

        public PackObjects createPack() {
            PackNode pack = new PackNode();
            DefaultMutableTreeNode n = TreetableTestClass.this.treetable.getSelectedNode();
            if (n == null) {
                return null;
            }
            int[] sels = TreetableTestClass.this.treetable.getSelectedIndices();
            for (int i = 0; i < sels.length; ++i) {
                DefaultMutableTreeNode nd = (DefaultMutableTreeNode)TreetableTestClass.this.treetable.getValueAt(sels[i], 0);
                Object userobj = nd.getUserObject();
                Class<?> tip = userobj.getClass();
                if (tip != ControllerNode.class) continue;
                ControllerNode controllerNode = (ControllerNode)userobj;
                pack.add(controllerNode);
                pack.setNode(controllerNode, nd);
                pack.setNodeHash(controllerNode, new Integer(nd.hashCode()));
            }
            return pack;
        }

        public boolean isInhibitExport() {
            return false;
        }

        public void exportDone(PackObjects packObjects) {
            DefaultTreeModel model = (DefaultTreeModel)TreetableTestClass.this.treeMdl;
            ControllerNode item2 = null;
            DefaultMutableTreeNode node = null;
            Vector<DefaultMutableTreeNode> nodesToDelete = new Vector<DefaultMutableTreeNode>();
            for (ControllerNode item2 : packObjects) {
                node = packObjects.getNode(item2);
                nodesToDelete.add(node);
            }
            RemoveMultipleNodesUndoableEdit multipleNodeDelete = new RemoveMultipleNodesUndoableEdit(nodesToDelete);
            multipleNodeDelete.execute();
            multipleNodeDelete.setIsSignificant(false);
            TreetableTestClass.this.treetable.repaint();
        }

        public boolean isGlobalPack() {
            return true;
        }

        public boolean canImport(PackObjects packObjects, DefaultMutableTreeNode parentNode) {
            Object parentObj = parentNode.getUserObject();
            return parentObj.getClass() == ControllerNode.class;
        }

        public boolean importData(PackObjects packObjects, DefaultMutableTreeNode parentNode, DefaultMutableTreeNode dropNode, int dropNodeIndex, boolean isMove) {
            ImportaMultipleNodesUndoableEdit importAction = new ImportaMultipleNodesUndoableEdit(parentNode, packObjects, dropNodeIndex);
            Vector<DefaultMutableTreeNode> newNodes = importAction.execute();
            TreetableTestClass.this.treetable.repaint();
            return true;
        }

        public boolean isTreatDropOnAsNear(PackObjects packObjects, DefaultMutableTreeNode targetNode) {
            ControllerNode controllerNode = (ControllerNode)targetNode.getUserObject();
            return controllerNode.getType() == 2;
        }

        public boolean isTreatPasteAsDropOn(PackObjects packObjects, DefaultMutableTreeNode targetNode) {
            ControllerNode controllerNode = (ControllerNode)targetNode.getUserObject();
            return controllerNode.getType() == 1;
        }
    };

    public TreetableTestClass() {
        this.setLayout(new BorderLayout());
        this.rowModel = new NodeRowModel();
        this.mdl = DefaultTreetableModel.createOutlineModel(this.rowModel);
        this.treetable = new Treetable(new DefaultTreetableCellRenderer());
        this.treeMdl = this.mdl.getTreeModel();
        this.treetable.setRootVisible(false);
        this.mdl.setNodeColumnName("Cod \n (String)");
        this.treetable.setModel(this.mdl);
        this.tableMdl = this.treetable.getModel();
        this.selectionHandler = new TreetableListSelectionHandler(this.treetable);
        this.treetable.getSelectionModel().addListSelectionListener(this.selectionHandler);
        this.treetable.setRenderDataProvider(new RenderData());
        this.treetable.setSelectionMode(2);
        this.treetable.getTableHeader().setReorderingAllowed(false);
        this.columns = this.treetable.getColumnModel();
        this.treetable.setAutoResizeMode(2);
        this.treetable.setFillsViewportHeight(true);
        this.treetable.setShowHorizontalLines(true);
        this.treetable.setShowVerticalLines(true);
        this.multirenderer = new MultilineHeaderRenderer();
        this.treetable.setDragEnabled(true);
        this.treetable.setDropMode(DropMode.ON_OR_INSERT_ROWS);
        this.treetable.setTransferHandler(new TreetableTransferHandler(this.transferDataProvider));
        this.toolBar = this.createToolBar();
        this.add((Component)this.toolBar, "North");
        this.makeTree();
        RowWarningHeaderData listTreetableModel = new RowWarningHeaderData(this.tableMdl);
        JWarningRowBar rowHeader = new JWarningRowBar((JTable)this.treetable, listTreetableModel);
        JScrollPane scrollPane = new JScrollPane(this.treetable);
        scrollPane.setRowHeaderView(rowHeader);
        this.add((Component)scrollPane, "Center");
    }

    private JToolBar createToolBar() {
        JToolBar localToolBar = new JToolBar("Toolbar");
        this.buttonAdd = new JButton("Add node");
        this.buttonAdd.setActionCommand(ACTION_ADD);
        this.buttonAdd.setToolTipText("Add a node");
        this.buttonAdd.addActionListener(this);
        localToolBar.add(this.buttonAdd);
        this.buttonAdd = new JButton("Del node");
        this.buttonAdd.setActionCommand(ACTION_DELETE);
        this.buttonAdd.setToolTipText("Delete a node");
        this.buttonAdd.addActionListener(this);
        localToolBar.add(this.buttonAdd);
        localToolBar.setFocusable(false);
        localToolBar.setFloatable(false);
        localToolBar.setRollover(false);
        return localToolBar;
    }

    private void makeTree() {
        DefaultTreeModel model = (DefaultTreeModel)this.treeMdl;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        ControllerNode element = new ControllerNode();
        root.setUserObject(element);
        int count = 30;
        for (int i = 0; i < count; ++i) {
            element = new ControllerNode();
            DefaultMutableTreeNode nd = new DefaultMutableTreeNode(element);
            int auxCount = RandomDataGenerator.getRandomInt(3);
            for (int j = 0; j < auxCount; ++j) {
                element = new ControllerNode();
                DefaultMutableTreeNode auxNd = new DefaultMutableTreeNode(element);
                nd.add(auxNd);
            }
            root.add(nd);
        }
        model.reload(root);
        this.treetable.expandNode(root);
    }

    private DefaultMutableTreeNode insertEchipamentToNode_silent(DefaultMutableTreeNode parinte, ControllerNode controllerNode, int position) {
        DefaultMutableTreeNode nd = new DefaultMutableTreeNode(controllerNode, true);
        parinte.insert(nd, position);
        return nd;
    }

    private UndoableEdit removeNodeFromParent_semiloud(DefaultMutableTreeNode n) {
        RemoveNodeFromParentStandardUndoableEdit removeAction = new RemoveNodeFromParentStandardUndoableEdit(this.treetable, n);
        removeAction.execute();
        return removeAction;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (ACTION_ADD.equals(cmd)) {
            this.fireActionAdd();
        } else if (ACTION_DELETE.equals(cmd)) {
            this.fireActionDelete();
        }
    }

    public void fireActionAdd() {
        DefaultTreeModel model = (DefaultTreeModel)this.treeMdl;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        DefaultMutableTreeNode parent = this.treetable.getSelectedNode();
        if (parent == null) {
            parent = root;
        }
        ControllerNode controllerNode = new ControllerNode();
        DefaultMutableTreeNode nd = new DefaultMutableTreeNode(controllerNode);
        InsertNodeToParentStandardUndoableEdit insertEdit = new InsertNodeToParentStandardUndoableEdit(this.treetable, nd, parent, parent.getChildCount());
        insertEdit.execute();
        this.repaint();
    }

    public void fireActionDelete() {
        DefaultTreeModel model = (DefaultTreeModel)this.treeMdl;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        Vector<DefaultMutableTreeNode> nodesToDelete = new Vector<DefaultMutableTreeNode>();
        int[] selectedIndices = this.treetable.getSelectedIndices();
        if (selectedIndices.length <= 0) {
            return;
        }
        for (int i = selectedIndices.length - 1; i >= 0; --i) {
            int j = selectedIndices[i];
            DefaultMutableTreeNode selectedNode = this.treetable.getNodeAt(j);
            if (selectedNode == null) continue;
            nodesToDelete.add(selectedNode);
        }
        RemoveMultipleNodesUndoableEdit multipleNodeDelete = new RemoveMultipleNodesUndoableEdit(nodesToDelete);
        multipleNodeDelete.execute();
        this.repaint();
    }

    private static void createAndShowGUI() {
        TreetableTestClass.initLookAndFeel();
        JFrame frame = new JFrame("TreetableTestClass");
        frame.setDefaultCloseOperation(3);
        TreetableTestClass testClass = new TreetableTestClass();
        frame.add(testClass);
        frame.setSize(500, 500);
        frame.setLocationByPlatform(true);
        frame.setVisible(true);
    }

    public static void initLookAndFeel() {
        String lookAndFeel = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Locale.setDefault(new Locale("ro", "RO"));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreetableTestClass.createAndShowGUI();
            }
        });
    }

    private class RowWarningHeaderData
    extends WarningRowBarModel {
        public RowWarningHeaderData(TableModel tabelModel) {
            super(tabelModel);
        }

        public WarningBarCellData getWarningBarCellData(Object tableObject) {
            if (tableObject instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)tableObject;
                ControllerNode controllerNode = (ControllerNode)node.getUserObject();
                WarningBarCellData cellData = new WarningBarCellData();
                if (node.getLevel() == 1) {
                    cellData.setText(node.getParent().getIndex(node) + "");
                }
                if (controllerNode.getType() == 1) {
                    cellData.setState(2);
                    cellData.setTooltipText("Tooltip text");
                    Vector<RunnableSuggestion> suggestions = new Vector<RunnableSuggestion>();
                    suggestions.add(new RunnableSuggestion(){

                        public String getName() {
                            return "test suggestion";
                        }

                        public void run() {
                            System.out.println(this.getName());
                        }
                    });
                    suggestions.add(new RunnableSuggestion(){

                        public String getName() {
                            return "another entry";
                        }

                        public void run() {
                            System.out.println(this.getName());
                        }
                    });
                    cellData.setSuggestions(suggestions);
                }
                return cellData;
            }
            throw new ClassCastException();
        }
    }

    private class RenderData
    implements RenderDataProvider {
        private MultilineHeaderRenderer headerRenderer = new MultilineHeaderRenderer();

        public String getDisplayName(Object o) {
            String name = "";
            DefaultMutableTreeNode nod = (DefaultMutableTreeNode)o;
            ControllerNode usernod = (ControllerNode)nod.getUserObject();
            name = usernod.getCod();
            return name;
        }

        public int getColumnPrefferedWidth() {
            return 200;
        }

        public TableCellRenderer getColumnHeaderRenderer() {
            return this.headerRenderer;
        }

        public Color getBackground(Object o) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)o;
            ControllerNode userObject = (ControllerNode)node.getUserObject();
            switch (userObject.getType()) {
                case 0: {
                    return new Color(0, 0, 255);
                }
                case 1: {
                    return new Color(255, 200, 200);
                }
                case 2: {
                    return new Color(200, 255, 200);
                }
            }
            return null;
        }

        public Color getForeground(Object o) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)o;
            ControllerNode userObject = (ControllerNode)node.getUserObject();
            switch (userObject.getType()) {
                case 0: {
                    return new Color(255, 255, 255);
                }
            }
            return null;
        }

        public String getTooltipText(Object o) {
            return null;
        }

        public Icon getIcon(Object o, boolean isExpanded) {
            return null;
        }

        public boolean isGrouping(Object o) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)o;
            ControllerNode userObject = (ControllerNode)node.getUserObject();
            return userObject.getType() == 0;
        }

        public int getDecimalScale() {
            return 3;
        }
    }

    private class NodeRowModel
    implements RowModel {
        private int scale = 2;
        private MultilineHeaderRenderer headerRenderer = new MultilineHeaderRenderer();

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return BigDecimal.class;
                }
                case 2: {
                    return Double.class;
                }
            }
            assert (false);
            return null;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Name \n(String)";
                }
                case 1: {
                    return "Value \n(BigDecimal)";
                }
                case 2: {
                    return "Another value \n(Double)";
                }
            }
            assert (false);
            return null;
        }

        public int getColumnPrefferedWidth(int column) {
            switch (column) {
                case 0: {
                    return 100;
                }
                case 1: {
                    return 100;
                }
                case 2: {
                    return 100;
                }
            }
            assert (false);
            return 0;
        }

        public TableCellRenderer getColumnHeaderRenderer(int column) {
            return this.headerRenderer;
        }

        public CellEditor getColumnCellEditor(int column) {
            return null;
        }

        public Object getValueFor(Object node, int column) {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)node;
            if (currentNode == null) {
                return null;
            }
            ControllerNode n = (ControllerNode)currentNode.getUserObject();
            switch (column) {
                case 0: {
                    return n.getName();
                }
                case 1: {
                    return n.getValue();
                }
                case 2: {
                    return n.getAnotherValue();
                }
            }
            assert (false);
            return null;
        }

        public String getTooltipTextFor(Object node, int column) {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)node;
            if (currentNode == null) {
                return null;
            }
            ControllerNode n = (ControllerNode)currentNode.getUserObject();
            if (n.getType() == 1 && (column == 2 || column == 0)) {
                return "ole";
            }
            return null;
        }

        public boolean isCellEditable(Object node, int column) {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)node;
            if (currentNode == null) {
                return false;
            }
            ControllerNode n = (ControllerNode)currentNode.getUserObject();
            return n.getType() == 1;
        }

        public boolean setValueFor(Object node, int column, Object value) {
            return false;
        }

        public boolean isCellImportant(Object node, boolean isExpanded, int column) {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)node;
            if (currentNode == null) {
                return false;
            }
            ControllerNode n = (ControllerNode)currentNode.getUserObject();
            return n.getType() == 0 && column == 1 && isExpanded;
        }

        public String getOverwriteString(Object node, boolean isExpanded, int column) {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)node;
            if (currentNode == null) {
                return null;
            }
            ControllerNode n = (ControllerNode)currentNode.getUserObject();
            if (n.getType() == 2) {
                if (column == 1) {
                    return "";
                }
                if (column == 2) {
                    return "- \" -";
                }
            } else if (n.getType() == 0 && column == 1 && isExpanded) {
                return "";
            }
            return null;
        }

        public Color getOverwriteBackground(Object node, boolean isExpanded, int column) {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)node;
            if (currentNode == null) {
                return null;
            }
            ControllerNode n = (ControllerNode)currentNode.getUserObject();
            if (n.getType() == 0) {
                if (column == 0) {
                    return Color.CYAN;
                }
            } else if (n.getType() == 2 && column == 2) {
                return Color.LIGHT_GRAY;
            }
            return null;
        }

        public Color getOverwriteForeground(Object node, boolean isExpanded, int column) {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)node;
            if (currentNode == null) {
                return null;
            }
            ControllerNode n = (ControllerNode)currentNode.getUserObject();
            if (n.getType() == 0 ? column == 0 : n.getType() == 2 && column == 2) {
                return Color.RED;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RemoveMultipleNodesUndoableEdit
    extends AbstractUndoableEdit {
        Vector<DefaultMutableTreeNode> deletedNodes;
        Vector<UndoableEdit> controllerActions;
        Vector<UndoableEdit> guiActions;
        Hashtable<UndoableEdit, UndoableEdit> obiectNotifications;
        UndoableEdit frahtAction;
        private boolean isSignificant;

        public RemoveMultipleNodesUndoableEdit(Vector<DefaultMutableTreeNode> deletedNodes) {
            this.deletedNodes = deletedNodes;
            this.controllerActions = new Vector();
            this.guiActions = new Vector();
            this.obiectNotifications = new Hashtable();
            this.isSignificant = true;
        }

        public void execute() {
            DefaultTreeModel model = (DefaultTreeModel)TreetableTestClass.this.treeMdl;
            for (DefaultMutableTreeNode deleteNode : this.deletedNodes) {
                UndoableEdit guiremove = TreetableTestClass.this.removeNodeFromParent_semiloud(deleteNode);
            }
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
        }

        public void setIsSignificant(boolean value) {
            this.isSignificant = value;
        }

        @Override
        public boolean isSignificant() {
            return this.isSignificant;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ImportaMultipleNodesUndoableEdit
    extends AbstractUndoableEdit {
        DefaultMutableTreeNode parentNode;
        Vector<ControllerNode> controllerNode;
        int position;
        UndoableEdit controllerAction;
        Vector<DefaultMutableTreeNode> newNodes;
        UndoableEdit removeEdit;

        public ImportaMultipleNodesUndoableEdit(DefaultMutableTreeNode parentNode, Vector<ControllerNode> controllerNodes, int position) {
            this.parentNode = parentNode;
            this.controllerNode = controllerNodes;
            this.position = position;
            this.newNodes = new Vector();
            this.removeEdit = null;
        }

        public Vector<DefaultMutableTreeNode> execute() {
            DefaultTreeModel model = (DefaultTreeModel)TreetableTestClass.this.treeMdl;
            for (ControllerNode nodeItem : this.controllerNode) {
                ControllerNode controllerNodNou = nodeItem.cloneaza();
                DefaultMutableTreeNode newNode = TreetableTestClass.this.insertEchipamentToNode_silent(this.parentNode, controllerNodNou, this.position);
                this.newNodes.add(newNode);
                model.nodesWereInserted(this.parentNode, new int[]{this.position++});
            }
            TreetableTestClass.this.treetable.expandNode(this.parentNode);
            for (DefaultMutableTreeNode nodSelectie : this.newNodes) {
                TreetableTestClass.this.treetable.selectAndScrollToNode(nodSelectie);
            }
            return this.newNodes;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InsertMultipleNodesUndoableEdit
    extends AbstractUndoableEdit {
        DefaultMutableTreeNode parentNode;
        Vector<ControllerNode> controllerNode;
        int position;
        UndoableEdit controllerAction;
        Vector<DefaultMutableTreeNode> newNodes;
        UndoableEdit removeEdit;

        public InsertMultipleNodesUndoableEdit(DefaultMutableTreeNode parentNode, Vector<ControllerNode> controllerNodes, int position) {
            this.parentNode = parentNode;
            this.controllerNode = controllerNodes;
            this.position = position;
            this.newNodes = new Vector();
            this.removeEdit = null;
        }

        public Vector<DefaultMutableTreeNode> execute() {
            DefaultTreeModel model = (DefaultTreeModel)TreetableTestClass.this.treeMdl;
            for (ControllerNode nodeItem : this.controllerNode) {
                DefaultMutableTreeNode newNode = TreetableTestClass.this.insertEchipamentToNode_silent(this.parentNode, nodeItem, this.position);
                this.newNodes.add(newNode);
                model.nodesWereInserted(this.parentNode, new int[]{this.position++});
            }
            TreetableTestClass.this.treetable.expandNode(this.parentNode);
            for (DefaultMutableTreeNode nodSelectie : this.newNodes) {
                TreetableTestClass.this.treetable.selectAndScrollToNode(nodSelectie);
            }
            return this.newNodes;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
        }
    }
}

