/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Random;

public class RandomDataGenerator {
    private static final String charset = "!0123456789abcdefghijklmnopqrstuvwxyz";
    private static final int TEST_DECIMAL_SCALE = 3;
    private static Random rand = new Random(System.currentTimeMillis());

    public static String getRandomString(int length) {
        return RandomDataGenerator.getRandomString(rand, length);
    }

    private static String getRandomString(Random rand, int length) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int pos = rand.nextInt(charset.length());
            sb.append(charset.charAt(pos));
        }
        return sb.toString();
    }

    public static int getRandomInt() {
        return rand.nextInt();
    }

    public static int getRandomInt(int limit) {
        return rand.nextInt(limit);
    }

    public static int getRandomInt(int min, int max) {
        int diff = max - min;
        return rand.nextInt(diff) + min;
    }

    public static BigDecimal getRandomBigDecimal() {
        return RandomDataGenerator.getRandomBigDecimal(rand, BigDecimal.ZERO, BigDecimal.ONE, 3);
    }

    public static BigDecimal getRandomBigDecimal(BigDecimal limit) {
        return RandomDataGenerator.getRandomBigDecimal(rand, BigDecimal.ZERO, limit, 3);
    }

    public static BigDecimal getRandomBigDecimal(BigDecimal min, BigDecimal max) {
        return RandomDataGenerator.getRandomBigDecimal(rand, min, max, 3);
    }

    private static BigDecimal getRandomBigDecimal(Random rand, BigDecimal min, BigDecimal max, int scale) {
        BigDecimal diff = max.subtract(min);
        BigDecimal bigDecimal = new BigDecimal(rand.nextDouble());
        bigDecimal = bigDecimal.multiply(diff);
        bigDecimal = bigDecimal.add(min);
        bigDecimal = bigDecimal.setScale(scale, RoundingMode.HALF_EVEN);
        return bigDecimal;
    }
}

