/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.celleditors;

import exenne.components.textfield.validator.IValidateString;
import exenne.components.textfield.validator.JValidatorTextfield;
import exenne.components.utils.NumberUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class DefaultBigDecimalCellEditor
extends AbstractCellEditor
implements TableCellEditor,
IValidateString {
    JValidatorTextfield editingComp = new JValidatorTextfield(BorderFactory.createLineBorder(Color.BLACK));
    protected int clickCountToStart = 1;

    public DefaultBigDecimalCellEditor() {
        this.editingComp.setHorizontalAlignment(4);
        this.editingComp.setValidator(this);
    }

    public boolean validate(String text) {
        return NumberUtils.isValidNumber(text);
    }

    public boolean stopCellEditing() {
        if (this.editingComp.isValidValue()) {
            return super.stopCellEditing();
        }
        return false;
    }

    public Object getCellEditorValue() {
        String editedValue = this.editingComp.getText();
        return NumberUtils.toBigDecimal(editedValue);
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    public void setClickCountToStart(int clickCountToStart) {
        this.clickCountToStart = clickCountToStart;
    }

    public boolean isCellEditable(EventObject e) {
        return !(e instanceof MouseEvent) || ((MouseEvent)e).getClickCount() >= this.clickCountToStart;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value != null) {
            this.editingComp.setText(((BigDecimal)value).stripTrailingZeros().toPlainString());
        } else {
            this.editingComp.setText("0");
        }
        this.editingComp.setCaretPosition(0);
        this.editingComp.selectAll();
        return this.editingComp;
    }
}

