/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.checktree;

import exenne.components.checktree.CheckTreeCellRenderer;
import exenne.components.checktree.CheckTreeSelectionListener;
import exenne.components.checktree.CheckTreeSelectionModel;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class CheckTreeManager
extends MouseAdapter
implements TreeSelectionListener {
    private CheckTreeSelectionModel selectionModel;
    private JTree tree = new JTree();
    int hotspot;
    Vector<CheckTreeSelectionListener> listeners;
    private static final String TOGGLE_PATH = "toggle";

    public CheckTreeManager(JTree tree) {
        this.hotspot = new JCheckBox().getPreferredSize().width;
        this.tree = tree;
        this.selectionModel = new CheckTreeSelectionModel(tree.getModel());
        tree.setCellRenderer(new CheckTreeCellRenderer(tree.getCellRenderer(), this.selectionModel));
        tree.addMouseListener(this);
        this.selectionModel.addTreeSelectionListener(this);
        this.listeners = new Vector();
        this.initKeyBindings();
    }

    public void mouseClicked(MouseEvent me) {
        TreePath path = this.tree.getPathForLocation(me.getX(), me.getY());
        if (path == null) {
            return;
        }
        if (me.getX() > this.tree.getPathBounds((TreePath)path).x + this.hotspot) {
            return;
        }
        this.togglePathState(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void togglePathState(TreePath path) {
        boolean selected = this.selectionModel.isPathSelected(path, true);
        this.selectionModel.removeTreeSelectionListener(this);
        try {
            if (selected) {
                this.selectionModel.removeSelectionPath(path);
            } else {
                this.selectionModel.addSelectionPath(path);
            }
        }
        finally {
            this.selectionModel.addTreeSelectionListener(this);
            this.tree.treeDidChange();
            this.notifyListeners(path);
        }
    }

    public void initKeyBindings() {
        ActionMap map = this.tree.getActionMap();
        AbstractAction actionEnter = new AbstractAction(TOGGLE_PATH){

            public void actionPerformed(ActionEvent e) {
                TreePath treePath = CheckTreeManager.this.tree.getSelectionPath();
                if (treePath != null) {
                    CheckTreeManager.this.togglePathState(treePath);
                }
            }
        };
        map.put(actionEnter.getValue("Name"), actionEnter);
        InputMap imap = this.tree.getInputMap();
        imap.put(KeyStroke.getKeyStroke("SPACE"), actionEnter.getValue("Name"));
    }

    public CheckTreeSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void valueChanged(TreeSelectionEvent e) {
        this.tree.treeDidChange();
    }

    public void addCheckedTreeSelectionListener(CheckTreeSelectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeCheckedTreeSelectionListener(CheckTreeSelectionListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners(TreePath path) {
        for (CheckTreeSelectionListener listener : this.listeners) {
            listener.pathStateChanged(path);
        }
    }
}

