/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.coloredtable.filter;

import javax.swing.RowFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeneralRowFilter
extends RowFilter<Object, Object> {
    private int[] columns;

    public GeneralRowFilter(int[] columns) {
        GeneralRowFilter.checkIndices(columns);
        this.columns = columns;
    }

    @Override
    public boolean include(RowFilter.Entry<? extends Object, ? extends Object> value) {
        int count = value.getValueCount();
        if (this.columns.length > 0) {
            for (int i = this.columns.length - 1; i >= 0; --i) {
                int index = this.columns[i];
                if (index >= count || !this.include(value, index)) continue;
                return true;
            }
        } else {
            while (--count >= 0) {
                if (!this.include(value, count)) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract boolean include(RowFilter.Entry<? extends Object, ? extends Object> var1, int var2);

    private static void checkIndices(int[] columns) {
        for (int i = columns.length - 1; i >= 0; --i) {
            if (columns[i] >= 0) continue;
            throw new IllegalArgumentException("Index must be >= 0");
        }
    }
}

