/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.jtable.viewportcontainer;

import exenne.components.jtable.viewportcontainer.IViewportAdditionalContainer;
import exenne.components.utils.MouseEventForwarder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;

public class JScrollableBottomSpacingContainer
extends JPanel
implements IViewportAdditionalContainer {
    private static final int DEFAULT_SPACER = 100;
    private JComponent component;
    private int spacerHeight;
    private JPanel fillPanel;

    public JScrollableBottomSpacingContainer(JComponent component) {
        this(component, 100);
    }

    public JScrollableBottomSpacingContainer(JComponent component, int spacerHeight) {
        this.component = component;
        this.spacerHeight = spacerHeight;
        this.setLayout(new BorderLayout());
        this.fillPanel = new JPanel();
        this.fillPanel.setPreferredSize(new Dimension(10, spacerHeight));
        this.fillPanel.setMaximumSize(new Dimension(10, spacerHeight));
        this.fillPanel.setMinimumSize(new Dimension(10, spacerHeight));
        this.fillPanel.setBackground(component.getBackground());
        this.fillPanel.setOpaque(true);
        this.fillPanel.setFocusable(false);
        MouseEventForwarder mouseEventForwarder = new MouseEventForwarder(component);
        this.fillPanel.addMouseListener(mouseEventForwarder);
        this.add((Component)component, "Center");
        this.add((Component)this.fillPanel, "South");
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (this.component instanceof Scrollable) {
            return ((Scrollable)((Object)this.component)).getScrollableUnitIncrement(visibleRect, orientation, direction);
        }
        return 10;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (this.component instanceof Scrollable) {
            return ((Scrollable)((Object)this.component)).getScrollableBlockIncrement(visibleRect, orientation, direction);
        }
        return 10;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.component instanceof Scrollable) {
            return ((Scrollable)((Object)this.component)).getScrollableTracksViewportWidth();
        }
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.component instanceof Scrollable) {
            boolean parentIsViewport = this.getParent() instanceof JViewport;
            boolean parentHeightIsBigger = this.getParent().getHeight() > this.component.getPreferredSize().height + this.spacerHeight;
            return parentIsViewport && parentHeightIsBigger;
        }
        return false;
    }

    public Dimension getPreferredScrollableViewportSize() {
        if (this.component instanceof Scrollable) {
            return ((Scrollable)((Object)this.component)).getPreferredScrollableViewportSize();
        }
        return new Dimension(100, 100);
    }
}

