/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.miscellaneous.labellines;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class JLinkButton
extends JButton {
    private static final Color LINK_COLOR = Color.blue;
    private static final Border LINK_BORDER = BorderFactory.createEmptyBorder(0, 0, 1, 0);
    private static final Border HOVER_BORDER = BorderFactory.createMatteBorder(0, 0, 1, 0, LINK_COLOR);

    public JLinkButton(String text, Icon icon) {
        super(text, icon);
        this.initializeButton();
    }

    public JLinkButton(Action a) {
        super(a);
        this.initializeButton();
    }

    public JLinkButton(String text) {
        super(text);
        this.initializeButton();
    }

    public JLinkButton(Icon icon) {
        super(icon);
        this.initializeButton();
    }

    public JLinkButton() {
        this.initializeButton();
    }

    private void initializeButton() {
        this.setBorder(LINK_BORDER);
        this.setForeground(LINK_COLOR);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setFocusPainted(false);
        this.setRequestFocusEnabled(false);
        this.setContentAreaFilled(false);
        this.addMouseListener(new LinkMouseListener());
    }

    private static class LinkMouseListener
    extends MouseAdapter {
        private LinkMouseListener() {
        }

        public void mouseEntered(MouseEvent e) {
            ((JComponent)e.getComponent()).setBorder(HOVER_BORDER);
        }

        public void mouseReleased(MouseEvent e) {
            ((JComponent)e.getComponent()).setBorder(LINK_BORDER);
        }

        public void mouseExited(MouseEvent e) {
            ((JComponent)e.getComponent()).setBorder(LINK_BORDER);
        }
    }
}

