/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.propertiespanel.editors;

import exenne.components.propertiespanel.IEditorChangeListener;
import exenne.components.propertiespanel.IPropertiesEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class JButtonPropertiesEditor
extends JPanel
implements IPropertiesEditor,
ActionListener {
    private Vector<IEditorChangeListener> editorChangeListeners;
    private JButton mainButton;
    private Runnable runnable;

    public JButtonPropertiesEditor(String buttonText) {
        JButton button = new JButton();
        button.setText(buttonText);
        this.init(button);
    }

    public JButtonPropertiesEditor(JButton button) {
        this.init(button);
    }

    private void init(JButton button) {
        this.setLayout(new BorderLayout());
        this.mainButton = button;
        this.runnable = null;
        this.mainButton.setHorizontalAlignment(0);
        this.mainButton.addActionListener(this);
        this.add((Component)this.mainButton, "Center");
        this.editorChangeListeners = new Vector();
    }

    public JComponent getContainerComponent() {
        return this;
    }

    public JComponent getEditorComponent() {
        return this.mainButton;
    }

    public void setEditorName(String name) {
        this.setName(name);
    }

    public void setValue(Class objectClass, Object renderedObject) {
        Runnable auxRunnable;
        if (Runnable.class != objectClass) {
            throw new UnsupportedOperationException(objectClass + " not supported in JColorIcon");
        }
        this.runnable = auxRunnable = (Runnable)renderedObject;
    }

    public Object getValue(Class objectClass) {
        if (Runnable.class == objectClass) {
            return this.runnable;
        }
        throw new UnsupportedOperationException(objectClass + " not supported in JColorIcon");
    }

    public void actionPerformed(ActionEvent e) {
        if (this.runnable != null) {
            this.runnable.run();
        }
        for (IEditorChangeListener iEditorChangeListener : this.editorChangeListeners) {
            iEditorChangeListener.fireValueChanged();
        }
    }

    public void addEditorChangeListener(IEditorChangeListener listener) {
        this.editorChangeListeners.add(listener);
    }

    public void removeEditorChangeListener(IEditorChangeListener listener) {
        this.editorChangeListeners.remove(listener);
    }
}

