/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.propertiespanel.editors;

import exenne.components.propertiespanel.IEditorChangeListener;
import exenne.components.propertiespanel.IPropertiesEditor;
import exenne.components.propertiespanel.undecided.UndecidedBoolean;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class JCheckBoxPropertiesEditor
extends JCheckBox
implements IPropertiesEditor,
ItemListener {
    private Vector<IEditorChangeListener> editorChangeListeners;
    private boolean isUndecided;
    private String checkBoxText;

    public JCheckBoxPropertiesEditor(String text, Icon icon, boolean selected) {
        super(text, icon, selected);
        this.initialize();
    }

    public JCheckBoxPropertiesEditor(String text, Icon icon) {
        super(text, icon);
        this.initialize();
    }

    public JCheckBoxPropertiesEditor(String text, boolean selected) {
        super(text, selected);
        this.initialize();
    }

    public JCheckBoxPropertiesEditor(Action a) {
        super(a);
        this.initialize();
    }

    public JCheckBoxPropertiesEditor(String text) {
        super(text);
        this.initialize();
    }

    public JCheckBoxPropertiesEditor(Icon icon, boolean selected) {
        super(icon, selected);
        this.initialize();
    }

    public JCheckBoxPropertiesEditor(Icon icon) {
        super(icon);
        this.initialize();
    }

    public JCheckBoxPropertiesEditor() {
        this.initialize();
    }

    private void initialize() {
        this.editorChangeListeners = new Vector();
        this.addItemListener(this);
        this.checkBoxText = this.getText();
    }

    public JComponent getContainerComponent() {
        return this;
    }

    public JComponent getEditorComponent() {
        return this;
    }

    public void setEditorName(String name) {
        this.setName(name);
    }

    public void setValue(Class objectClass, Object renderedObject) {
        if (Boolean.class == objectClass) {
            Boolean auxBoolean = (Boolean)renderedObject;
            this.setSelected(auxBoolean);
        } else if (UndecidedBoolean.class == objectClass) {
            UndecidedBoolean auxUndecidedBoolean = (UndecidedBoolean)renderedObject;
            Boolean auxBoolean = auxUndecidedBoolean.getBoolean();
            this.setSelected(auxBoolean);
            this.setUndecided(auxUndecidedBoolean.isUndecided());
        } else {
            throw new UnsupportedOperationException(objectClass + " not supported in JCheckBox");
        }
    }

    public Object getValue(Class objectClass) {
        if (Boolean.class == objectClass) {
            Boolean auxBoolean = this.isSelected();
            return auxBoolean;
        }
        if (UndecidedBoolean.class == objectClass) {
            Boolean auxBoolean = this.isSelected();
            return new UndecidedBoolean(auxBoolean, this.isUndecided);
        }
        throw new UnsupportedOperationException(objectClass + " not supported in JCheckBox");
    }

    private void setUndecided(boolean isUndecided) {
        if (this.isUndecided != isUndecided) {
            this.isUndecided = isUndecided;
            if (isUndecided) {
                this.setText("<valori diferite> " + this.checkBoxText);
            } else {
                this.setText(this.checkBoxText);
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        this.setUndecided(false);
        for (IEditorChangeListener iEditorChangeListener : this.editorChangeListeners) {
            iEditorChangeListener.fireValueChanged();
        }
    }

    public void addEditorChangeListener(IEditorChangeListener listener) {
        this.editorChangeListeners.add(listener);
    }

    public void removeEditorChangeListener(IEditorChangeListener listener) {
        this.editorChangeListeners.remove(listener);
    }
}

