/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.sidebar;

import exenne.components.sidebar.IResizableBorder;
import exenne.components.sidebar.JResizableBorder;
import exenne.components.sidebar.JResizeMarker;
import exenne.components.sidebar.JSensitivePanel;
import exenne.components.sidebar.JSideBarIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;

public class JSideBar
extends JPanel
implements ActionListener {
    public static final int EAST_WEST = 0;
    public static final int WEST_EAST = 1;
    public static final int SOUTH_NORTH = 2;
    public static final int NORTH_SOUTH = 3;
    public static final int OPENED = 0;
    public static final int CLOSED = 1;
    public static final int INFINITE = 21000;
    private int length;
    private int draglength;
    private int offsetSize;
    private int buttonSize;
    private int borderSize;
    private int type;
    private int state;
    private boolean dragging;
    private JButton button;
    private IResizableBorder border;
    private Border noborder;
    private JPanel sidebar;
    private JSensitivePanel parent;
    MouseInputListener resizeListener = new MouseInputAdapter(){
        private int cursor;
        private Point startPos = null;

        public void mouseMoved(MouseEvent me) {
            IResizableBorder border = (IResizableBorder)JSideBar.this.getBorder();
            JSideBar.this.setCursor(Cursor.getPredefinedCursor(border.getResizeCursor(me)));
        }

        public void mouseExited(MouseEvent mouseEvent) {
            JSideBar.this.setCursor(Cursor.getDefaultCursor());
        }

        public void mousePressed(MouseEvent me) {
            IResizableBorder border = (IResizableBorder)JSideBar.this.getBorder();
            this.cursor = border.getResizeCursor(me);
            this.startPos = me.getPoint();
        }

        public void mouseDragged(MouseEvent me) {
            if (this.startPos != null) {
                Point aux = JSideBar.this.sidebar.getLocation();
                int dx = me.getX() - this.startPos.x;
                int dy = me.getY() - this.startPos.y;
                JSideBar.this.dragging = true;
                switch (this.cursor) {
                    case 9: {
                        this.startPos = me.getPoint();
                        JSideBar.this.setLength(JSideBar.this.draglength + dy);
                        int totallength = aux.y + JSideBar.this.length + JSideBar.this.buttonSize + JSideBar.this.borderSize;
                        JResizeMarker marker = new JResizeMarker(aux.x, totallength, JSideBar.this.sidebar.getWidth(), 0);
                        JSideBar.this.parent.setDrag(marker);
                        JSideBar.this.parent.repaint();
                        break;
                    }
                    case 8: {
                        this.startPos = me.getPoint();
                        JSideBar.this.setLength(JSideBar.this.draglength - dy);
                        int totallength = aux.y + JSideBar.this.sidebar.getHeight() - JSideBar.this.length - JSideBar.this.buttonSize - JSideBar.this.borderSize;
                        JResizeMarker marker = new JResizeMarker(aux.x, totallength, JSideBar.this.sidebar.getWidth(), 0);
                        JSideBar.this.parent.setDrag(marker);
                        JSideBar.this.parent.repaint();
                        break;
                    }
                    case 11: {
                        this.startPos = me.getPoint();
                        JSideBar.this.setLength(JSideBar.this.draglength + dx);
                        int totallength = aux.x + JSideBar.this.length + JSideBar.this.buttonSize + JSideBar.this.borderSize;
                        JResizeMarker marker = new JResizeMarker(totallength, aux.y, JSideBar.this.sidebar.getHeight(), 1);
                        JSideBar.this.parent.setDrag(marker);
                        JSideBar.this.parent.repaint();
                        break;
                    }
                    case 10: {
                        this.startPos = me.getPoint();
                        JSideBar.this.setLength(JSideBar.this.draglength - dx);
                        int totallength = aux.x + JSideBar.this.sidebar.getWidth() - JSideBar.this.length - JSideBar.this.borderSize - JSideBar.this.buttonSize;
                        JResizeMarker marker = new JResizeMarker(totallength, aux.y, JSideBar.this.sidebar.getHeight(), 1);
                        JSideBar.this.parent.setDrag(marker);
                        JSideBar.this.parent.repaint();
                    }
                }
                JSideBar.this.setCursor(Cursor.getPredefinedCursor(this.cursor));
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.startPos = null;
            if (JSideBar.this.dragging) {
                JSideBar.this.dragging = false;
                JSideBar.this.draglength = JSideBar.this.length;
                JSideBar.this.parent.endDrag();
                JSideBar.this.didResized();
            }
        }
    };

    public JSideBar(int type, int state, int length, JSensitivePanel parent) {
        this.sidebar = this;
        this.parent = parent;
        this.draglength = this.length = length;
        this.buttonSize = 24;
        this.borderSize = 6;
        this.offsetSize = 20;
        this.type = type;
        this.state = state;
        this.dragging = false;
        this.setOpaque(false);
        this.setBackground(Color.blue);
        this.setLayout(new BorderLayout());
        this.button = new JButton();
        this.button.setActionCommand("unroll");
        this.button.setToolTipText("Deschide SideBarul");
        this.noborder = this.getBorder();
        switch (type) {
            case 0: {
                Icon icon = JSideBarIcons.LEFT.getIcon();
                this.button.setIcon(icon);
                this.button.setPreferredSize(new Dimension(this.buttonSize, 0));
                this.setPreferredSize(new Dimension(this.buttonSize, 0));
                this.button.addActionListener(this);
                this.add((Component)this.button, "West");
                this.border = new JResizableBorder(this.borderSize, 8);
                break;
            }
            case 1: {
                Icon icon = JSideBarIcons.RIGHT.getIcon();
                this.button.setIcon(icon);
                this.button.setPreferredSize(new Dimension(this.buttonSize, 0));
                this.setPreferredSize(new Dimension(this.buttonSize, 0));
                this.button.addActionListener(this);
                this.add((Component)this.button, "East");
                this.border = new JResizableBorder(this.borderSize, 4);
                break;
            }
            case 2: {
                Icon icon = JSideBarIcons.UP.getIcon();
                this.button.setIcon(icon);
                this.button.setPreferredSize(new Dimension(0, this.buttonSize));
                this.setPreferredSize(new Dimension(0, this.buttonSize));
                this.button.addActionListener(this);
                this.add((Component)this.button, "North");
                this.border = new JResizableBorder(this.borderSize, 1);
                break;
            }
            case 3: {
                Icon icon = JSideBarIcons.DOWN.getIcon();
                this.button.setIcon(icon);
                this.button.setPreferredSize(new Dimension(0, this.buttonSize));
                this.setPreferredSize(new Dimension(0, this.buttonSize));
                this.button.addActionListener(this);
                this.add((Component)this.button, "South");
                this.border = new JResizableBorder(this.borderSize, 2);
                break;
            }
        }
        if (this.state == 0) {
            this.unroll();
            this.setBorder(this.border);
        }
        JPanel aditional = new JPanel();
        aditional.setBackground(Color.RED);
        this.add((Component)aditional, "Center");
    }

    public JSideBar(int type, JSensitivePanel parent) {
        this(type, 1, 200, parent);
    }

    public Component add(Component component) {
        super.add(component, "Center");
        return this;
    }

    public void setLength(int length) {
        int maximum = 21000;
        if (this.dragging) {
            this.draglength = length;
            if (length >= 0) {
                switch (this.type) {
                    case 0: 
                    case 1: {
                        maximum = this.parent.getWidth();
                        break;
                    }
                    case 2: 
                    case 3: {
                        maximum = this.parent.getHeight();
                        break;
                    }
                }
                maximum = maximum / 2 - this.buttonSize - this.borderSize - this.offsetSize;
                if (maximum < 0) {
                    maximum = 0;
                }
                this.length = maximum < length ? maximum : length;
            }
        } else {
            switch (this.type) {
                case 0: 
                case 1: {
                    maximum = this.parent.getWidth();
                    break;
                }
                case 2: 
                case 3: {
                    maximum = this.parent.getHeight();
                    break;
                }
            }
            maximum = maximum / 2 - this.buttonSize - this.borderSize - this.offsetSize;
            if (maximum < 0) {
                maximum = 0;
            }
            this.length = maximum < length ? maximum : length;
            this.draglength = length;
        }
    }

    public void notifyResize() {
        this.setLength(this.length);
        if (this.state == 0) {
            this.unroll();
        }
    }

    public void unroll() {
        this.state = 0;
        this.button.setActionCommand("roll");
        this.button.setToolTipText("Inchide SideBarul");
        int totalsize = this.buttonSize + this.length + this.borderSize;
        switch (this.type) {
            case 0: {
                Icon icon = JSideBarIcons.RIGHT.getIcon();
                this.button.setIcon(icon);
                this.setPreferredSize(new Dimension(totalsize, 0));
                break;
            }
            case 1: {
                Icon icon = JSideBarIcons.LEFT.getIcon();
                this.button.setIcon(icon);
                this.setPreferredSize(new Dimension(totalsize, 0));
                break;
            }
            case 2: {
                Icon icon = JSideBarIcons.DOWN.getIcon();
                this.button.setIcon(icon);
                this.setPreferredSize(new Dimension(0, totalsize));
                break;
            }
            case 3: {
                Icon icon = JSideBarIcons.UP.getIcon();
                this.button.setIcon(icon);
                this.setPreferredSize(new Dimension(0, totalsize));
                break;
            }
        }
        this.setBorder(this.border);
    }

    public void roll() {
        this.state = 1;
        this.button.setActionCommand("unroll");
        this.button.setToolTipText("Deschide SideBarul");
        switch (this.type) {
            case 0: {
                Icon icon = JSideBarIcons.LEFT.getIcon();
                this.button.setIcon(icon);
                this.setPreferredSize(new Dimension(this.buttonSize, 0));
                break;
            }
            case 1: {
                Icon icon = JSideBarIcons.RIGHT.getIcon();
                this.button.setIcon(icon);
                this.setPreferredSize(new Dimension(this.buttonSize, 0));
                break;
            }
            case 2: {
                Icon icon = JSideBarIcons.UP.getIcon();
                this.button.setIcon(icon);
                this.setPreferredSize(new Dimension(0, this.buttonSize));
                break;
            }
            case 3: {
                Icon icon = JSideBarIcons.DOWN.getIcon();
                this.button.setIcon(icon);
                this.setPreferredSize(new Dimension(0, this.buttonSize));
                break;
            }
        }
        this.setBorder(this.noborder);
    }

    public void toggle() {
        if (this.state == 1) {
            this.unroll();
        } else {
            this.roll();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("unroll")) {
            this.unroll();
            this.revalidate();
        } else if (cmd.equals("roll")) {
            this.roll();
            this.revalidate();
        }
    }

    public void setBorder(Border border) {
        this.removeMouseListener(this.resizeListener);
        this.removeMouseMotionListener(this.resizeListener);
        if (border instanceof IResizableBorder) {
            this.addMouseListener(this.resizeListener);
            this.addMouseMotionListener(this.resizeListener);
        }
        super.setBorder(border);
    }

    private void didResized() {
        int totalsize = this.buttonSize + this.length + this.borderSize;
        switch (this.type) {
            case 0: {
                this.setPreferredSize(new Dimension(totalsize, 0));
                break;
            }
            case 1: {
                this.setPreferredSize(new Dimension(totalsize, 0));
                break;
            }
            case 2: {
                this.setPreferredSize(new Dimension(0, totalsize));
                break;
            }
            case 3: {
                this.setPreferredSize(new Dimension(0, totalsize));
                break;
            }
        }
        this.revalidate();
    }
}

