/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.tabbedpane;

import exenne.components.tabbedpane.INeedCleanup;
import exenne.components.tabbedpane.JTabCloseButton;
import exenne.components.utils.ComponentsUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class JComponentForTab
extends JPanel
implements ActionListener {
    private JTabbedPane tabbedpane;
    private String title;
    private JLabel label;
    private JPanel buttonPanel;
    private JButton closeButton;

    public JComponentForTab(String title, JTabbedPane pane) {
        this(null, title, pane, false);
    }

    public JComponentForTab(Icon icon, String title, JTabbedPane pane) {
        this(icon, title, pane, false);
    }

    public JComponentForTab(Icon icon, String title, JTabbedPane pane, boolean shouldBeBold) {
        if (pane == null) {
            throw new NullPointerException("TabbedPane is null");
        }
        this.tabbedpane = pane;
        this.title = title;
        this.setLayout(new FlowLayout(0, 0, 0));
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        this.label = new JLabel(title);
        this.label.setIcon(icon);
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        if (shouldBeBold) {
            ComponentsUtils.setFontBold(this.label);
        }
        this.add((Component)this.label, "Center");
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 1));
        this.buttonPanel.setOpaque(false);
        this.closeButton = new JTabCloseButton();
        this.closeButton.addActionListener(this);
        this.buttonPanel.add(this.closeButton);
        this.buttonPanel.add(Box.createVerticalGlue());
        this.add((Component)this.buttonPanel, "East");
    }

    public void setTitle(String title) {
        this.label.setText(title);
    }

    public void setIcon(Icon icon) {
        this.label.setIcon(icon);
    }

    public void setTextBold(boolean shouldBeBold) {
        if (shouldBeBold) {
            ComponentsUtils.setFontBold(this.label);
        } else {
            ComponentsUtils.setFontPlain(this.label);
        }
    }

    public void actionPerformed(ActionEvent e) {
        int i = this.tabbedpane.indexOfTabComponent(this);
        Component component = this.tabbedpane.getComponentAt(i);
        if (i != -1) {
            this.tabbedpane.remove(i);
            if (component instanceof INeedCleanup) {
                ((INeedCleanup)((Object)component)).cleanup();
            }
        }
    }
}

