/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.treetable.search;

import exenne.components.tree.search.INodeSearchCriteria;
import exenne.components.treetable.RenderDataProvider;
import exenne.components.treetable.RowModel;
import exenne.components.treetable.Treetable;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultMutableTreeNode;

public class TreetableStringSearchCriteria
implements INodeSearchCriteria {
    private Treetable treetable;
    private String searchString;
    private Pattern pattern;
    private RenderDataProvider renderDataProvider;
    private RowModel rowModel;
    private int[] stringColumnVector;

    public TreetableStringSearchCriteria(Treetable treetable, String searchString) {
        this.treetable = treetable;
        this.searchString = searchString;
        this.pattern = Pattern.compile(Pattern.quote(searchString), 2);
        this.renderDataProvider = treetable.getRenderDataProvider();
        this.rowModel = treetable.getTreetableModel().getRowModel();
        int stringColumns = 0;
        for (int i = 0; i < this.rowModel.getColumnCount(); ++i) {
            if (!String.class.equals((Object)this.rowModel.getColumnClass(i))) continue;
            ++stringColumns;
        }
        int index = 0;
        this.stringColumnVector = new int[stringColumns];
        for (int i = 0; i < this.rowModel.getColumnCount(); ++i) {
            if (!String.class.equals((Object)this.rowModel.getColumnClass(i))) continue;
            this.stringColumnVector[index] = i;
        }
    }

    public boolean validateNode(DefaultMutableTreeNode node) {
        boolean searchResult = false;
        String displayName = this.renderDataProvider.getDisplayName(node);
        if (displayName != null) {
            searchResult = this.pattern.matcher(displayName).find() || searchResult;
        }
        for (int i : this.stringColumnVector) {
            String value = (String)this.rowModel.getValueFor(node, i);
            if (value == null) continue;
            searchResult = this.pattern.matcher(value).find() || searchResult;
        }
        return searchResult;
    }
}

