/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.builtin;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.openide.util.bundle.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DateDayRange
implements Validator<String> {
    private DateFormat dateFormatter;
    private Date max;
    private Date min;
    private boolean isExclusive;
    private String textMin = "";
    private String textMax = "";

    public DateDayRange(DateFormat dateFormatter, Date min, Date max) {
        this(dateFormatter, min, max, false);
    }

    public DateDayRange(DateFormat dateFormatter, Date min, Date max, boolean isExclusive) {
        this.dateFormatter = dateFormatter;
        this.min = min;
        this.max = max;
        this.isExclusive = isExclusive;
        if (min != null) {
            this.textMin = dateFormatter.format(min);
        }
        if (max != null) {
            this.textMax = dateFormatter.format(max);
        }
    }

    @Override
    public boolean validate(Problems problems, String compName, String model) {
        try {
            Date valDate = this.dateFormatter.parse(model);
            boolean minOk = true;
            if (this.min != null) {
                int differenceMin = this.compareDayDate(valDate, this.min);
                if (this.isExclusive) {
                    minOk = differenceMin > 0;
                } else {
                    boolean bl = minOk = differenceMin >= 0;
                }
                if (!minOk) {
                    problems.add(NbBundle.getMessage(DateDayRange.class, "DATE_TOO_LOW", new Object[]{compName, this.textMin, model}));
                }
            }
            boolean maxOk = true;
            if (this.max != null) {
                int differenceMax = this.compareDayDate(this.max, valDate);
                if (this.isExclusive) {
                    maxOk = differenceMax > 0;
                } else {
                    boolean bl = maxOk = differenceMax >= 0;
                }
                if (!maxOk) {
                    problems.add(NbBundle.getMessage(DateDayRange.class, "DATE_TOO_HIGH", new Object[]{compName, this.textMax, model}));
                }
            }
            return minOk && maxOk;
        }
        catch (ParseException e) {
            return true;
        }
    }

    private int compareDayDate(Date date1, Date date2) {
        int yearDifference = date1.getYear() - date2.getYear();
        if (yearDifference != 0) {
            return yearDifference;
        }
        int monthsDifference = date1.getMonth() - date2.getMonth();
        if (monthsDifference != 0) {
            return monthsDifference;
        }
        int daysDifference = date1.getDate() - date2.getDate();
        if (daysDifference != 0) {
            return daysDifference;
        }
        return 0;
    }
}

