/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.builtin;

import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.openide.util.bundle.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GreaterOrEqualValueValidator
implements Validator<String> {
    private Number min;

    public GreaterOrEqualValueValidator(Number min) {
        this.min = min;
    }

    @Override
    public boolean validate(Problems problems, String compName, String model) {
        try {
            double d = Double.parseDouble(model);
            double minx = this.min.doubleValue();
            if (d < minx) {
                String problem = NbBundle.getMessage(GreaterOrEqualValueValidator.class, "GREATER_OR_EQUAL_VALUE", compName, model, this.min);
                problems.add(problem);
                return false;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return true;
    }
}

