/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.ui;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.netbeans.validation.api.Severity;

public class ComponentDecorator {
    public Border createProblemBorder(Component c, Border originalBorder, Severity severity) {
        JTextField textField;
        boolean isLeftAligned = true;
        if (c instanceof JTextField && (textField = (JTextField)c).getHorizontalAlignment() == 4) {
            isLeftAligned = false;
        }
        return new ColorizingBorder(originalBorder, severity, isLeftAligned);
    }

    public static final ComponentDecorator noOpComponentDecorator() {
        return new ComponentDecorator(){

            public Border createProblemBorder(Component c, Border originalBorder, Severity severity) {
                return originalBorder;
            }
        };
    }

    private static class ColorizingBorder
    implements Border {
        private final Border real;
        private final Severity severity;
        private boolean isLeftAligned;

        public ColorizingBorder(Border real, Severity severity) {
            this.real = real;
            this.severity = severity;
            this.isLeftAligned = true;
        }

        public ColorizingBorder(Border real, Severity severity, boolean isLeftAligned) {
            this.real = real;
            this.severity = severity;
            this.isLeftAligned = isLeftAligned;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.real.paintBorder(c, g, x, y, width, height);
            g.setColor(this.severity.color());
            Graphics2D gg = (Graphics2D)g;
            Composite composite = gg.getComposite();
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.05f);
            Insets ins = this.getBorderInsets(c);
            try {
                gg.setComposite(alpha);
                gg.fillRect(x, y, width, height);
            }
            finally {
                gg.setComposite(composite);
            }
            BufferedImage badge = this.severity.image();
            int by = c.getHeight() / 2 - badge.getHeight() / 2;
            int w = Math.max(2, ins.left);
            int bx = this.isLeftAligned ? x + width - (badge.getHeight() + w * 2) : x + w * 2;
            gg.drawRenderedImage(badge, AffineTransform.getTranslateInstance(bx, by));
        }

        public Insets getBorderInsets(Component c) {
            return this.real.getBorderInsets(c);
        }

        public boolean isBorderOpaque() {
            return false;
        }
    }
}

