/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.controller.externalcalls;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import ro.genomeartist.components.swingworkers.progressworker.AbstractProgressCallable;
import ro.genomeartist.gui.controller.externalcalls.RawFileFilter;
import ro.genomeartist.gui.controller.externalcalls.ResultParsing;
import ro.genomeartist.gui.controller.externalcalls.actions.AddSearchFileCallable;
import ro.genomeartist.gui.controller.externalcalls.actions.AddSearchFolderCallable;
import ro.genomeartist.gui.controller.externalcalls.actions.CreateSearchFileCallable;
import ro.genomeartist.gui.controller.externalcalls.actions.DeleteMultipleFilesCallable;
import ro.genomeartist.gui.controller.externalcalls.actions.DeleteSearchFileCallable;
import ro.genomeartist.gui.controller.externalcalls.actions.RunDataHashingUtilityCallable;
import ro.genomeartist.gui.controller.externalcalls.actions.RunExpansionGenerationCallable;
import ro.genomeartist.gui.controller.externalcalls.actions.RunSearchCallable;
import ro.genomeartist.gui.controller.externalcalls.actions.StartServerCallable;
import ro.genomeartist.gui.controller.genes.GeneItem;
import ro.genomeartist.gui.controller.genes.GeneVector;
import ro.genomeartist.gui.controller.query.MainResult;
import ro.genomeartist.gui.controller.query.SearchQuery;
import ro.genomeartist.gui.controller.settings.SearchFile;
import ro.genomeartist.gui.controller.settings.SearchFileSequence;
import ro.genomeartist.gui.controller.settings.SearchFolder;
import ro.genomeartist.gui.utils.MyUtils;
import ro.genomeartist.gui.utils.ReadOnlyConfiguration;
import ro.genomeartist.gui.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalLink {
    private static final String FASTA_MARKER = ">";
    private static final String FIELD_SEPARATOR = " ; ";
    private static final Pattern REGEX_NAME = Pattern.compile("name=([^;]*);");
    private static final Pattern REGEX_ID = Pattern.compile("ID=([^;]*);");
    private static final Pattern REGEX_LOCUS = Pattern.compile("loc=[^;:]*:(complement)*[\\(]*(\\d+)\\.{2}(\\d+)[\\)]*;");
    private static final Pattern REGEX_CYTO = Pattern.compile("derived_computed_cyto=([^ ;]+)%");
    public static final int PARAM_WINDOW_SIZE = 10;
    public static final int PARAM_EXPANDED_SIZE = 4;
    private static Process serverProcess = null;
    private static Process searchProcess = null;

    public static AbstractProgressCallable<Boolean> getStartServerCallable() {
        return new StartServerCallable();
    }

    public static void stopServer() {
        if (serverProcess != null) {
            serverProcess.destroy();
        }
        Object[] args = new String[]{ReadOnlyConfiguration.getString("cleanerFile")};
        try {
            String line;
            ProcessBuilder pbuild = new ProcessBuilder((String[])args);
            Process process = pbuild.start();
            InputStream is = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            System.out.printf("Output of running %s is:", Arrays.toString(args));
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
            System.out.println("Server stopped");
        }
        catch (IOException iOException) {
            System.err.println("Eroare la oprire server");
            iOException.printStackTrace();
        }
    }

    public static void stopClient() {
        if (searchProcess != null) {
            searchProcess.destroy();
        }
    }

    public static AbstractProgressCallable<Boolean> getSearchCallable(SearchQuery searchQuery, File outputFile) {
        return new RunSearchCallable(searchQuery, outputFile);
    }

    public static void setSearchProcess(Process newProcess) {
        searchProcess = newProcess;
    }

    public static void setServerProcess(Process newProcess) {
        serverProcess = newProcess;
    }

    public static MainResult readResultFile(File file) {
        return ResultParsing.readResult(file);
    }

    public static void saveBestResult(MainResult mainResult) {
        ResultParsing.saveBestResult(mainResult);
    }

    public static AbstractProgressCallable<Boolean> getDataHashingCallable(File rawFile) {
        return new RunDataHashingUtilityCallable(rawFile);
    }

    public static AbstractProgressCallable<Boolean> getExpansionGenerationCallable() {
        return new RunExpansionGenerationCallable();
    }

    public static AbstractProgressCallable<SearchFile> getCreateSearchFileCallable(SearchFileSequence searchFileSequence) {
        return new CreateSearchFileCallable(searchFileSequence);
    }

    public static AbstractProgressCallable<Boolean> getAddSearchFileCallable(SearchFile searchFile) {
        return new AddSearchFileCallable(searchFile);
    }

    public static AbstractProgressCallable<Vector<SearchFile>> getAddSearchFolderCallable(SearchFolder searchFolderRaw, boolean isTransposon) {
        return new AddSearchFolderCallable(searchFolderRaw, isTransposon);
    }

    public static AbstractProgressCallable<Boolean> getDeleteSearchFileCallable(SearchFile searchFile) {
        return new DeleteSearchFileCallable(searchFile);
    }

    public static AbstractProgressCallable<Boolean> getDeleteMultipleFileCallable(Vector<SearchFile> searchFiles) {
        return new DeleteMultipleFilesCallable(searchFiles);
    }

    public static Vector<File> getSequencesFromFolder(File folder) {
        Vector<File> fileVector = new Vector<File>();
        RawFileFilter rawFilter = new RawFileFilter();
        File[] templateFiles = folder.listFiles(rawFilter);
        for (int i = 0; i < templateFiles.length; ++i) {
            File file = templateFiles[i];
            fileVector.add(file);
        }
        return fileVector;
    }

    public static File getGeneFileForRaw(File rawFile) {
        String basename = MyUtils.getBasename(rawFile);
        File assumedFile = new File(basename + "_gene.fasta");
        if (assumedFile.exists()) {
            return assumedFile;
        }
        return null;
    }

    public static int fastaToGeneFile(File fastaFile, File geneFile) {
        int counter = 0;
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(fastaFile));
            BufferedWriter out = new BufferedWriter(new FileWriter(geneFile, false));
            GeneVector geneVector = new GeneVector();
            while ((line = in.readLine()) != null) {
                String end_locus;
                String start_locus;
                String name;
                if (!line.startsWith(FASTA_MARKER) || (name = StringUtils.regexFind(REGEX_NAME, line, 1)) == null) continue;
                String id = StringUtils.regexFind(REGEX_ID, line, 1);
                if (id == null) {
                    id = "none";
                }
                if ((start_locus = StringUtils.regexFind(REGEX_LOCUS, line, 2)) == null || (end_locus = StringUtils.regexFind(REGEX_LOCUS, line, 3)) == null) continue;
                String strand = StringUtils.regexFind(REGEX_LOCUS, line, 1);
                String cyto = StringUtils.regexFind(REGEX_CYTO, line, 1);
                if (cyto == null) {
                    cyto = "none";
                }
                GeneItem geneItem = new GeneItem();
                geneItem.setName(name);
                geneItem.setGeneId(id);
                geneItem.locationStart = Integer.parseInt(start_locus) - 1;
                geneItem.locationEnd = Integer.parseInt(end_locus) - 1;
                geneItem.setCyto(cyto);
                if (strand == null) {
                    geneItem.setIsComplement(false);
                } else {
                    geneItem.setIsComplement(true);
                }
                geneVector.add(geneItem);
            }
            Collections.sort(geneVector, new Comparator<GeneItem>(){

                @Override
                public int compare(GeneItem o1, GeneItem o2) {
                    return o1.getLocationStart() - o2.getLocationStart();
                }
            });
            for (GeneItem geneItem : geneVector) {
                out.write(geneItem.getName());
                out.write(FIELD_SEPARATOR);
                out.write(geneItem.getGeneId());
                out.write(FIELD_SEPARATOR);
                out.write(geneItem.locationStart + "");
                out.write(FIELD_SEPARATOR);
                out.write(geneItem.locationEnd + "");
                out.write(FIELD_SEPARATOR);
                if (geneItem.isComplement()) {
                    out.write("R");
                } else {
                    out.write("F");
                }
                out.write(FIELD_SEPARATOR);
                out.write(geneItem.getCyto());
                out.newLine();
            }
            counter = geneVector.size();
            in.close();
            out.close();
        }
        catch (FileNotFoundException ex) {
            System.out.println(ex.getMessage() + " in the specified directory.");
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        return counter;
    }

    public static void copyRawFile(File sourceFile, File destinationFile) {
        try {
            int len;
            FileInputStream in = new FileInputStream(sourceFile);
            FileOutputStream out = new FileOutputStream(destinationFile);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                for (int i = 0; i < buf.length; ++i) {
                    byte b = buf[i];
                    buf[i] = ExternalLink.byteToUppercase(b);
                }
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (FileNotFoundException ex) {
            System.out.println(ex.getMessage() + " in the specified directory.");
            System.exit(0);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public static byte byteToUppercase(byte b) {
        switch (b) {
            case 65: 
            case 97: {
                return 65;
            }
            case 67: 
            case 99: {
                return 67;
            }
            case 71: 
            case 103: {
                return 71;
            }
            case 84: 
            case 116: {
                return 84;
            }
        }
        return b;
    }

    public static void copyFile(File sourceFile, File destinationFile) {
        try {
            int len;
            FileInputStream in = new FileInputStream(sourceFile);
            FileOutputStream out = new FileOutputStream(destinationFile);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (FileNotFoundException ex) {
            System.out.println(ex.getMessage() + " in the specified directory.");
            System.exit(0);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public static void createEmptyFile(File newFile) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(newFile, false));
            out.close();
        }
        catch (IOException ex) {
            Logger.getLogger(ExternalLink.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void writeStringToFile(File newFile, String string) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(newFile, false));
            out.write(string);
            out.close();
        }
        catch (IOException ex) {
            Logger.getLogger(ExternalLink.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) {
        String inputFasta = ">FBgn0032620 type=gene; loc=2L:complement(16900535..16902189); ID=FBgn0032620; name=CG12288; dbxref=FlyBase:FBgn0032620,FlyBase:FBan0012288,FlyBase_Annotation_IDs:CG12288,GB_protein:AAF53587,GB:AA801811,GB:AY118842,GB_protein:AAM50702,UniProt/TrEMBL:Q8MSG1,UniProt/TrEMBL:Q9VJG2,INTERPRO:IPR000504,INTERPRO:IPR012677,EntrezGene:35027,DroID:FBgn0032620,DRSC:FBgn0032620,FlyAtlas:CG12288-RA,FlyMine:FBgn0032620,GenomeRNAi_gene:35027,modMine:FBgn0032620; derived_computed_cyto=36B4-36B4%3B Limits computationally determined from genome sequence between @P{lacW}Mhc<up>k10423</up>@%26@P{lacW}Cas<up>k03902</up>@ and @P{lacW}Aac11<up>k06710</up>@; gbunit=AE014134; MD5=d1bba921ea9542c7b890ba22cc2203f5; length=1655; release=r5.26; species=Dmel; ";
        String alternateFasta = ">FBgn0011823 type=gene; loc=2L:10056906..10060097; ID=FBgn0011823; name=Pen; dbxref=FlyBase:FBgn0011823,FlyBase:FBan0004799,FlyBase_Annotation_IDs:CG4799,GB_protein:AAF52853,FlyBase:FBgn0014274,FlyBase:FBgn0026803,FlyBase:FBgn0044610,GB:AA695740,GB:AA803647,GB:AA820973,GB:AA942615,GB:AC005734,GB:AC009744,GB:AI109333,GB:AI257091,GB:AI259659,GB:AI455357,GB:AI944500,GB:AI945098,GB:AI945110,GB:AI945973,GB:AI946350,GB:AI946675,GB:AI946703,GB:AI946866,GB:AI947113,GB:AQ026078,GB:AW944011,GB:AX154909,GB:AY061543,GB_protein:AAL29091,GB:BT003258,GB_protein:AAO25015,GB:CL610233,GB:CZ469793,GB:CZ475481,GB:U12269,GB_protein:AAA85260,GB:X85752,GB_protein:CAA59753,UniProt/Swiss-Prot:P52295,INTERPRO:IPR000225,INTERPRO:IPR002652,INTERPRO:IPR011989,INTERPRO:IPR016024,EntrezGene:34338,BIOGRID:60430,DroID:FBgn0011823,DRSC:FBgn0011823,FlyAtlas:CG4799-RA,FlyMine:FBgn0011823,GenomeRNAi_gene:34338,modMine:FBgn0011823; derived_computed_cyto=31A1-31A2%3B Limits computationally determined from genome sequence between @P{EP}CG4747<up>EP594</up>@%26@P{lacW}l(2)k13305<up>k13305</up>@ and @P{lacW}l(2)k06324<up>k06324</up>@; gbunit=AE014134; MD5=095aafb4ea812db94f9e94f330f35050; length=3192; release=r5.26; species=Dmel;";
        String problemQuery = ">FBgn0041004 type=gene; loc=2L:22736958..22742972; ID=FBgn0041004; name=CG17715; dbxref=FlyBase:FBgn0041004,FlyBase:FBan0017715,FlyBase_Annotation_IDs:CG17715,GB_protein:EAA46033,GB_protein:EAA46029,GB_protein:EAA46031,GB_protein:EAA46032,GB_protein:EAA46028,GB_protein:EAA46030,FlyBase:FBgn0041003,FlyBase:FBgn0047070,FlyBase:FBgn0063069,GB:AABU01002768,GB_protein:EAA46028,GB_protein:EAA46029,GB_protein:EAA46030,GB_protein:EAA46031,GB_protein:EAA46032,GB_protein:EAA46033,GB:AY071582,GB_protein:AAL49204,GB:AY113392,GB_protein:AAM29397,GB:BI166931,GB:BI375866,UniProt/TrEMBL:Q5LJR0,UniProt/TrEMBL:Q5LJR2,UniProt/TrEMBL:Q8SYF7,INTERPRO:IPR019537,EntrezGene:3355129,DRSC:FBgn0041004,FlyAtlas:CG17715-RD,FlyMine:FBgn0041004,modMine:FBgn0041004; MD5=d09e16c5f0bdeac27291109cbb4dd079; length=6015; release=r5.26; species=Dmel; ";
        Pattern pattern = Pattern.compile("derived_computed_cyto=([^ ;]+)%");
        String match = StringUtils.regexFind(pattern, alternateFasta, 1);
        System.out.println(match);
    }
}

