/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.controller.externalcalls;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Date;
import ro.genomeartist.gui.controller.finalresult.FinalResultItem;
import ro.genomeartist.gui.controller.finalresult.FinalResultSet;
import ro.genomeartist.gui.controller.finalresult.IntervalMappingItem;
import ro.genomeartist.gui.controller.finalresult.IntervalMappingSet;
import ro.genomeartist.gui.controller.genes.GeneItem;
import ro.genomeartist.gui.controller.partialresult.PartialResultItem;
import ro.genomeartist.gui.controller.partialresult.PartialResultSet;
import ro.genomeartist.gui.controller.query.InfoQuery;
import ro.genomeartist.gui.controller.query.MainResult;

public class ResultParsing {
    private static final int STRING_CONST = 128;
    private static final int STRING_GENE_CONST = 64;
    private static final byte DIRECTION_FORWARD = 70;
    private static final byte DIRECTION_COMPLEMENT = 82;

    public static MainResult readResult(File file) {
        try {
            MainResult mainResult = new MainResult();
            RandomAccessFile resultFile = new RandomAccessFile(file, "r");
            int offsetInfoQuery = ResultParsing.littleEndianToBigEndian(resultFile.readInt());
            int offsetFinalResultSet = ResultParsing.littleEndianToBigEndian(resultFile.readInt());
            int offsetPartialResultSet = ResultParsing.littleEndianToBigEndian(resultFile.readInt());
            int offsetBestResult = ResultParsing.littleEndianToBigEndian(resultFile.readInt());
            resultFile.seek(offsetInfoQuery);
            InfoQuery infoQuery = ResultParsing.readInfoQuery(resultFile);
            resultFile.seek(offsetFinalResultSet);
            FinalResultSet finalResultSet = ResultParsing.readFinalResultSet(resultFile, infoQuery.query.length());
            resultFile.seek(offsetPartialResultSet);
            PartialResultSet partialResultSet = ResultParsing.readPartialResultSet(resultFile, infoQuery.query.length());
            resultFile.seek(offsetBestResult);
            int bestResult = ResultParsing.littleEndianToBigEndian(resultFile.readInt());
            System.out.println("bestResult=" + bestResult);
            mainResult.infoQuery = infoQuery;
            mainResult.finalResultSet = finalResultSet;
            mainResult.partialResultSet = partialResultSet;
            mainResult.bestResult = bestResult != -1 ? (FinalResultItem)mainResult.finalResultSet.elementAt(bestResult) : null;
            resultFile.close();
            return mainResult;
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            return null;
        }
    }

    public static void saveBestResult(MainResult mainResult) {
        try {
            File sourceFile = mainResult.backgroundFile;
            int index = mainResult.finalResultSet.indexOf(mainResult.bestResult);
            RandomAccessFile resultFile = new RandomAccessFile(sourceFile, "rw");
            int offsetInfoQuery = ResultParsing.littleEndianToBigEndian(resultFile.readInt());
            int offsetFinalResultSet = ResultParsing.littleEndianToBigEndian(resultFile.readInt());
            int offsetPartialResultSet = ResultParsing.littleEndianToBigEndian(resultFile.readInt());
            int offsetBestResult = ResultParsing.littleEndianToBigEndian(resultFile.readInt());
            resultFile.seek(offsetBestResult);
            resultFile.write(index);
            resultFile.close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private static PartialResultSet readPartialResultSet(RandomAccessFile file, int lengthInitialQuery) throws IOException {
        PartialResultSet partialResultSet = new PartialResultSet();
        int partialResultsNumber = ResultParsing.littleEndianToBigEndian(file.readInt());
        for (int i = 0; i < partialResultsNumber; ++i) {
            PartialResultItem partialResultItem = ResultParsing.readPartialResultItem(file, lengthInitialQuery);
            partialResultSet.add(partialResultItem);
        }
        return partialResultSet;
    }

    private static PartialResultItem readPartialResultItem(RandomAccessFile file, int lengthInitialQuery) throws IOException {
        PartialResultItem partialResultItem = new PartialResultItem();
        partialResultItem.setFisierOrigine(ResultParsing.readString(file, 128));
        partialResultItem.setPozitieStartQuery(ResultParsing.littleEndianToBigEndian(file.readInt()));
        partialResultItem.setPozitieStartGenom(ResultParsing.littleEndianToBigEndian(file.readInt()));
        partialResultItem.setLengthQuery(ResultParsing.littleEndianToBigEndian(file.readInt()));
        partialResultItem.setLengthGenom(ResultParsing.littleEndianToBigEndian(file.readInt()));
        partialResultItem.setScore(ResultParsing.littleEndianToBigEndian(file.readInt()));
        partialResultItem.setLength(ResultParsing.littleEndianToBigEndian(file.readInt()));
        partialResultItem.setOut1(ResultParsing.readString(file, partialResultItem.getLength()));
        partialResultItem.setRelation(ResultParsing.readString(file, partialResultItem.getLength()));
        partialResultItem.setOut2(ResultParsing.readString(file, partialResultItem.getLength()));
        partialResultItem.setIsTransposon(ResultParsing.readBoolean(file));
        partialResultItem.setIsComplement(ResultParsing.readBoolean(file));
        partialResultItem.setLengthInitialQuery(lengthInitialQuery);
        return partialResultItem;
    }

    private static FinalResultSet readFinalResultSet(RandomAccessFile file, int lengthInitialQuery) throws IOException {
        FinalResultSet finalResultSet = new FinalResultSet();
        int finalResultNumber = ResultParsing.littleEndianToBigEndian(file.readInt());
        for (int i = 0; i < finalResultNumber; ++i) {
            FinalResultItem finalResultItem = ResultParsing.readFinalResultItem(file, lengthInitialQuery);
            finalResultSet.add(finalResultItem);
        }
        return finalResultSet;
    }

    private static FinalResultItem readFinalResultItem(RandomAccessFile file, int lengthInitialQuery) throws IOException {
        FinalResultItem finalResultItem = new FinalResultItem();
        finalResultItem.setScore(ResultParsing.littleEndianToBigEndian(file.readInt()));
        finalResultItem.setOutTotalLength(ResultParsing.littleEndianToBigEndian(file.readInt()));
        int outTotalLength = finalResultItem.getOutTotalLength();
        finalResultItem.setOut1(ResultParsing.readString(file, outTotalLength));
        finalResultItem.setRelation(ResultParsing.readString(file, outTotalLength));
        finalResultItem.setOut2(ResultParsing.readString(file, outTotalLength));
        finalResultItem.setLengthInitialQuery(lengthInitialQuery);
        int intervalMappingNumber = ResultParsing.littleEndianToBigEndian(file.readInt());
        finalResultItem.setIntervalMappingSet(ResultParsing.readIntervalMappingSet(file, intervalMappingNumber, finalResultItem.getLengthInitialQuery(), finalResultItem.getOutTotalLength()));
        return finalResultItem;
    }

    private static IntervalMappingSet readIntervalMappingSet(RandomAccessFile file, int intervalMappingItems, int lengthInitialQuery, int outStringTotalLength) throws IOException {
        IntervalMappingSet intervalMappingSet = new IntervalMappingSet();
        for (int i = 0; i < intervalMappingItems; ++i) {
            IntervalMappingItem intervalMappingItem = ResultParsing.readIntervalMappingItem(file, lengthInitialQuery, outStringTotalLength, intervalMappingSet);
            intervalMappingSet.add(intervalMappingItem);
        }
        return intervalMappingSet;
    }

    private static IntervalMappingItem readIntervalMappingItem(RandomAccessFile file, int lengthInitialQuery, int outStringTotalLength, IntervalMappingSet mappingParinte) throws IOException {
        IntervalMappingItem intervalMappingItem = new IntervalMappingItem(mappingParinte);
        intervalMappingItem.setFisierOrigine(ResultParsing.readString(file, 128));
        intervalMappingItem.setLengthInitialQuery(lengthInitialQuery);
        intervalMappingItem.setOutStringTotalLength(outStringTotalLength);
        intervalMappingItem.setPozitieQuery(ResultParsing.littleEndianToBigEndian(file.readInt()));
        intervalMappingItem.setPozitieStartGenom(ResultParsing.littleEndianToBigEndian(file.readInt()));
        intervalMappingItem.setLengthQuery(ResultParsing.littleEndianToBigEndian(file.readInt()));
        intervalMappingItem.setLengthGenom(ResultParsing.littleEndianToBigEndian(file.readInt()));
        intervalMappingItem.setOutStringOffset(ResultParsing.littleEndianToBigEndian(file.readInt()));
        intervalMappingItem.setOutStringLength(ResultParsing.littleEndianToBigEndian(file.readInt()));
        intervalMappingItem.setIsTransposon(ResultParsing.readBoolean(file));
        intervalMappingItem.setIsComplement(ResultParsing.readBoolean(file));
        int insideGeneNo = file.readByte();
        for (int i = 0; i < insideGeneNo; ++i) {
            GeneItem insideGene = ResultParsing.readGeneItem(file);
            if (intervalMappingItem.isComplement()) {
                intervalMappingItem.pushInsideGene(insideGene);
                continue;
            }
            intervalMappingItem.addInsideGene(insideGene);
        }
        boolean hasDownstreamGene = ResultParsing.readBoolean(file);
        if (hasDownstreamGene) {
            GeneItem downstreamGene = ResultParsing.readGeneItem(file);
            intervalMappingItem.setClosestDownstream(downstreamGene);
        } else {
            intervalMappingItem.setClosestDownstream(null);
        }
        boolean hasUpstreamGene = ResultParsing.readBoolean(file);
        if (hasUpstreamGene) {
            GeneItem upstreamGene = ResultParsing.readGeneItem(file);
            intervalMappingItem.setClosestUpstream(upstreamGene);
        } else {
            intervalMappingItem.setClosestUpstream(null);
        }
        return intervalMappingItem;
    }

    private static GeneItem readGeneItem(RandomAccessFile file) throws IOException {
        GeneItem geneItem = new GeneItem();
        geneItem.setName(ResultParsing.readString(file, 64));
        geneItem.setFisierOrigine(ResultParsing.readString(file, 128));
        geneItem.setLocationStart(ResultParsing.littleEndianToBigEndian(file.readInt()));
        geneItem.setLocationEnd(ResultParsing.littleEndianToBigEndian(file.readInt()));
        geneItem.setCyto(ResultParsing.readString(file, 64));
        geneItem.setGeneId(ResultParsing.readString(file, 64));
        int auxInt = ResultParsing.littleEndianToBigEndian(file.readInt());
        byte byteChar = (byte)auxInt;
        if (byteChar == 70) {
            geneItem.setIsComplement(false);
        } else if (byteChar == 82) {
            geneItem.setIsComplement(true);
        }
        return geneItem;
    }

    private static InfoQuery readInfoQuery(RandomAccessFile file) throws IOException {
        InfoQuery infoQuery = new InfoQuery();
        infoQuery.queryName = ResultParsing.readString(file, 128);
        int auxInt = ResultParsing.littleEndianToBigEndian(file.readInt());
        infoQuery.query = ResultParsing.readString(file, auxInt);
        long secondsFromEpoch = (long)ResultParsing.littleEndianToBigEndian(file.readInt()) * 1000L;
        infoQuery.searchDate = new Date(secondsFromEpoch);
        infoQuery.timpExecutie = ResultParsing.littleEndianToBigEndian(file.readInt());
        infoQuery.finalResultNumber = ResultParsing.littleEndianToBigEndian(file.readInt());
        infoQuery.partialResultNumber = ResultParsing.littleEndianToBigEndian(file.readInt());
        return infoQuery;
    }

    private static int littleEndianToBigEndian(int i) {
        return ((i & 0xFF) << 24) + ((i & 0xFF00) << 8) + ((i & 0xFF0000) >> 8) + (i >> 24 & 0xFF);
    }

    private static int bigEndianToLittleEndian(int i) {
        return ResultParsing.littleEndianToBigEndian(i);
    }

    private static String readString(RandomAccessFile file, int size) throws IOException {
        char[] chars = new char[size];
        int length = size;
        boolean stopRead = false;
        for (int i = 0; i < size; ++i) {
            char c = (char)file.readByte();
            if (c == '\u0000' && !stopRead) {
                stopRead = true;
                length = i;
            }
            if (stopRead) continue;
            chars[i] = c;
        }
        return new String(chars, 0, length);
    }

    private static boolean readBoolean(RandomAccessFile file) throws IOException {
        byte auxByte = file.readByte();
        return auxByte > 0;
    }

    public static void main(String[] args) {
        File file = new File("../fisier_rezultate_formatat.tress");
        MainResult mainResult = ResultParsing.readResult(file);
        if (mainResult == null) {
            System.out.println("erorr");
        }
    }
}

