/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.controller.externalcalls.actions;

import java.io.File;
import java.util.Vector;
import ro.genomeartist.components.swingworkers.progressworker.AbstractProgressCallable;
import ro.genomeartist.components.swingworkers.progressworker.ProgressInfoManager;
import ro.genomeartist.gui.controller.externalcalls.ExternalLink;
import ro.genomeartist.gui.controller.settings.SearchFile;
import ro.genomeartist.gui.controller.settings.SearchFolder;
import ro.genomeartist.gui.utils.MyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddSearchFolderCallable
extends AbstractProgressCallable<Vector<SearchFile>> {
    private SearchFolder searchFolderRaw;
    private boolean isTransposon;

    public AddSearchFolderCallable(SearchFolder searchFolderRaw, boolean isTransposon) {
        this.searchFolderRaw = searchFolderRaw;
        this.isTransposon = isTransposon;
    }

    public Vector<SearchFile> call() throws Exception {
        Vector<SearchFile> newSearchFiles = new Vector<SearchFile>();
        Vector<File> rawFiles = ExternalLink.getSequencesFromFolder(this.searchFolderRaw.folderLocation);
        int numberOfSeqFile = rawFiles.size();
        int step = 100 / numberOfSeqFile;
        int infLimit = 0;
        int supLimit = step;
        for (File rawFile : rawFiles) {
            File geneFile = ExternalLink.getGeneFileForRaw(rawFile);
            SearchFile newSearchFile = new SearchFile();
            newSearchFile.fileTitle = this.searchFolderRaw.fileTitle + "_" + MyUtils.getFilenameNoExt(rawFile);
            newSearchFile.rawLocation = rawFile;
            newSearchFile.geneLocation = geneFile;
            newSearchFile.isTransposon = this.isTransposon;
            this.setProgressRange(infLimit, supLimit);
            AbstractProgressCallable<Boolean> runDataHashing = ExternalLink.getAddSearchFileCallable(newSearchFile);
            runDataHashing.setProgressInfoManager((ProgressInfoManager)this);
            runDataHashing.call();
            infLimit = supLimit;
            supLimit += step;
            newSearchFiles.add(newSearchFile);
        }
        return newSearchFiles;
    }
}

