/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.controller.finalresult;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.UIManager;
import ro.genomeartist.gui.controller.finalresult.FinalResultItem;
import ro.genomeartist.gui.controller.finalresult.IntervalMappingItem;
import ro.genomeartist.gui.custompaint.DrawingConstants;
import ro.genomeartist.gui.custompaint.ImageManipulation;
import ro.genomeartist.gui.custompaint.ImageVector;
import ro.genomeartist.gui.interfaces.ICanPaint;
import ro.genomeartist.gui.utils.DNAUtils;
import ro.genomeartist.gui.utils.ReadWriteConfiguration;

public class FinalResultItemAlignment
implements ICanPaint {
    private FinalResultItem finalResultItem;
    private Font monospaceFont_gui;
    private Font monospaceFont_report;
    private int offset;
    private static final int CHARS_LEFT = 8;
    private static final int CHARS_RIGHT = 8;
    private static final int CHARS_INDEX = 4;

    public FinalResultItemAlignment(FinalResultItem finalResultItem) {
        this.finalResultItem = finalResultItem;
        Font font = UIManager.getDefaults().getFont("Table.font");
        this.monospaceFont_gui = new Font("Monospaced", 0, font.getSize());
        this.monospaceFont_report = new Font("Monospaced", 0, 10);
        this.offset = Integer.parseInt((String)ReadWriteConfiguration.get("NUMBERING_OFFSET"));
    }

    public void paint(Graphics g, int width, int height, Color bgColor, Color fgColor) {
        Graphics2D g2d = (Graphics2D)g;
        int indexWidth = 0;
        g2d.setFont(this.monospaceFont_gui);
        FontMetrics fontMetrics = g2d.getFontMetrics();
        int lineHeight = fontMetrics.getHeight();
        String queryLeftEnd = " " + this.offset + " ";
        int rightEnd = this.finalResultItem.getLengthInitialQuery() - 1 + this.offset;
        String queryRightEnd = " " + rightEnd + " ";
        int leftTextLength = fontMetrics.stringWidth(queryLeftEnd);
        int rigthTextLength = fontMetrics.stringWidth(queryRightEnd);
        int centerTextOffset = 2;
        int centerTextLength = fontMetrics.stringWidth(this.finalResultItem.getOut1());
        Iterator intervale = this.finalResultItem.getIntervalMappingSet().iterator();
        Color colorIntervalBorder = DrawingConstants.COLOR_CHENAR_BORDER;
        Color colorIntervalFill = DrawingConstants.COLOR_CHENAR_FILL;
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.setColor(bgColor);
        g2d.fillRect(0, 0, width, height);
        int localX = 10;
        int localY = 10 + 3 * lineHeight;
        g2d.setColor(colorIntervalBorder);
        g2d.drawString(queryLeftEnd, localX, localY);
        localX = 10 + leftTextLength + centerTextLength;
        localY = 10 + 3 * lineHeight;
        g2d.setColor(colorIntervalBorder);
        g2d.drawString(queryRightEnd, localX, localY);
        int indexInterval = 1;
        while (intervale.hasNext()) {
            int auxInt;
            IntervalMappingItem intervalMappingItem = (IntervalMappingItem)intervale.next();
            int markerDeviationLeft = intervalMappingItem.getPozitieStartQuery() != 0 ? centerTextOffset : 0;
            int markerDeviationRight = intervalMappingItem.getPozitieStartQuery() + intervalMappingItem.getLengthQuery() != this.finalResultItem.getLengthInitialQuery() ? centerTextOffset : 2 * centerTextOffset;
            int markerLeft = (int)((double)intervalMappingItem.getOutStringOffset() / (double)this.finalResultItem.getOutTotalLength() * (double)centerTextLength);
            int intervalLeft = 10 + markerLeft + leftTextLength + markerDeviationLeft;
            int markerRight = (int)((double)(intervalMappingItem.getOutStringOffset() + intervalMappingItem.getOutStringLength()) / (double)this.finalResultItem.getOutTotalLength() * (double)centerTextLength);
            int intervalRight = 10 + markerRight + leftTextLength + markerDeviationRight;
            int intervalWidth = intervalRight - intervalLeft;
            String textIndexInterval = "[" + indexInterval + "] " + intervalMappingItem.getFisierOrigine();
            indexWidth = fontMetrics.stringWidth(textIndexInterval);
            if (indexWidth > intervalWidth) {
                textIndexInterval = "[" + indexInterval + "]";
                indexWidth = fontMetrics.stringWidth(textIndexInterval);
            }
            ++indexInterval;
            if (intervalMappingItem.isTransposon()) {
                colorIntervalBorder = DrawingConstants.COLOR_TRANSPOSON_BORDER;
                colorIntervalFill = DrawingConstants.COLOR_TRANSPOSON_FILL;
            } else {
                colorIntervalBorder = DrawingConstants.COLOR_GENOM_BORDER;
                colorIntervalFill = DrawingConstants.COLOR_GENOM_FILL;
            }
            g2d.setStroke(new BasicStroke(1.0f));
            localX = intervalLeft;
            localY = 10 + lineHeight;
            int localWidth = intervalWidth;
            int localHeight = 3 * lineHeight;
            g2d.setColor(colorIntervalFill);
            g2d.fillRoundRect(localX, localY, localWidth, localHeight, 5, 5);
            g2d.setColor(colorIntervalBorder);
            g2d.drawRoundRect(localX, localY, localWidth, localHeight, 5, 5);
            g2d.setStroke(new BasicStroke(2.0f));
            if (intervalWidth - 8 > 25) {
                auxInt = (intervalWidth - 25) / 2;
                localX = intervalLeft + auxInt;
                localY = 10 + 2 * lineHeight + lineHeight / 2;
                localWidth = 25;
                localHeight = 0;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(colorIntervalBorder);
                g2d.drawLine(localX, localY, localX + localWidth, localY + localHeight);
                auxInt = lineHeight / 2 - 4;
                if (intervalMappingItem.isComplement()) {
                    g2d.drawLine(localX -= 2, localY, localX + auxInt, localY - auxInt);
                    g2d.drawLine(localX, localY, localX + auxInt, localY + auxInt);
                } else {
                    localX = localX + localWidth + 2;
                    g2d.drawLine(localX, localY, localX - auxInt, localY - auxInt);
                    g2d.drawLine(localX, localY, localX - auxInt, localY + auxInt);
                }
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
            }
            Font oldFont = g2d.getFont();
            g2d.setFont(oldFont.deriveFont(1, oldFont.getSize() + 1));
            localX = intervalLeft + intervalWidth / 2 - indexWidth / 2;
            localY = 10 + 5 * lineHeight;
            g2d.setColor(colorIntervalBorder);
            g2d.drawString(textIndexInterval, localX, localY);
            g2d.setFont(oldFont);
            int textMarkerWidth = 4;
            int textMarkerHeight = 6;
            localX = intervalLeft;
            localY = 10 + lineHeight;
            g2d.setColor(colorIntervalBorder);
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.drawLine(localX, localY, localX, localY - textMarkerHeight);
            localX = intervalLeft;
            localY = 10 + lineHeight - textMarkerHeight;
            g2d.setColor(colorIntervalBorder);
            g2d.drawLine(localX, localY, localX + textMarkerWidth, localY);
            localX = intervalRight;
            localY = 10 + lineHeight;
            g2d.setColor(colorIntervalBorder);
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.drawLine(localX, localY, localX, localY - textMarkerHeight);
            localX = intervalRight;
            localY = 10 + lineHeight - textMarkerHeight;
            g2d.setColor(colorIntervalBorder);
            g2d.drawLine(localX, localY, localX - textMarkerWidth, localY);
            g2d.setStroke(new BasicStroke(2.0f));
            textMarkerWidth = 4;
            textMarkerHeight = 6;
            localX = intervalLeft;
            localY = 10 + 4 * lineHeight;
            g2d.setColor(colorIntervalBorder);
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.drawLine(localX, localY, localX, localY + textMarkerHeight);
            localX = intervalLeft;
            localY = 10 + 4 * lineHeight + textMarkerHeight;
            g2d.setColor(colorIntervalBorder);
            g2d.drawLine(localX, localY, localX + textMarkerWidth, localY);
            localX = intervalRight;
            localY = 10 + 4 * lineHeight;
            g2d.setColor(colorIntervalBorder);
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.drawLine(localX, localY, localX, localY + textMarkerHeight);
            localX = intervalRight;
            localY = 10 + 4 * lineHeight + textMarkerHeight;
            g2d.setColor(colorIntervalBorder);
            g2d.drawLine(localX, localY, localX - textMarkerWidth, localY);
            g2d.setStroke(new BasicStroke(2.0f));
            textMarkerWidth = 6;
            String auxString = intervalMappingItem.getPozitieStartQuery() + "";
            auxInt = fontMetrics.stringWidth(auxString);
            int sumInt = auxInt + 2 * textMarkerWidth;
            if (sumInt < intervalWidth) {
                localX = intervalLeft + textMarkerWidth;
                localY = 10 + lineHeight - 5;
                g2d.setColor(colorIntervalBorder);
                g2d.drawString(intervalMappingItem.getPozitieStartQuery() + "", localX, localY);
            }
            auxString = intervalMappingItem.getPozitieStopQuery() + "";
            sumInt = auxInt;
            auxInt = fontMetrics.stringWidth(auxString);
            if ((sumInt += auxInt + 2 * textMarkerWidth + 8) < intervalWidth) {
                localX = intervalRight - auxInt - textMarkerWidth;
                localY = 10 + lineHeight - 5;
                g2d.setColor(colorIntervalBorder);
                g2d.drawString(auxString, localX, localY);
            }
            textMarkerWidth = 6;
            auxString = intervalMappingItem.getPozitieStartGenom() + "";
            auxInt = fontMetrics.stringWidth(auxString);
            sumInt = auxInt + textMarkerWidth + indexWidth / 2;
            if (sumInt < intervalWidth / 2) {
                localX = intervalLeft + textMarkerWidth;
                localY = 10 + 5 * lineHeight;
                g2d.setColor(colorIntervalBorder);
                g2d.drawString(auxString, localX, localY);
            }
            auxString = intervalMappingItem.getPozitieStopGenom() + "";
            sumInt = auxInt;
            auxInt = fontMetrics.stringWidth(auxString);
            if ((sumInt += auxInt + 2 * textMarkerWidth + 8 + indexWidth) >= intervalWidth) continue;
            localX = intervalRight - auxInt - textMarkerWidth;
            localY = 10 + 5 * lineHeight;
            g2d.setColor(colorIntervalBorder);
            g2d.drawString(auxString, localX, localY);
        }
        localX = 10 + leftTextLength + centerTextOffset;
        localY = 10 + 2 * lineHeight - centerTextOffset;
        g2d.setColor(fgColor);
        g2d.drawString(this.finalResultItem.getOut1(), localX, localY);
        localX = 10 + leftTextLength + centerTextOffset;
        localY = 10 + 3 * lineHeight - centerTextOffset;
        g2d.setColor(fgColor);
        g2d.drawString(this.finalResultItem.getRelation(), localX, localY);
        localX = 10 + leftTextLength + centerTextOffset;
        localY = 10 + 4 * lineHeight - centerTextOffset;
        g2d.setColor(fgColor);
        g2d.drawString(this.finalResultItem.getOut2(), localX, localY);
    }

    public int getRecommendedHeight(JComponent component) {
        int lineHeight = component.getFontMetrics(this.monospaceFont_gui).getHeight();
        int recommendedSize = 20 + 7 * lineHeight;
        return recommendedSize;
    }

    public int getRecommendedWidth(JComponent component) {
        FontMetrics fontMetrics = component.getFontMetrics(this.monospaceFont_gui);
        int recommendedSize = fontMetrics.stringWidth(this.finalResultItem.getOut1());
        return recommendedSize += 20 + 2 * fontMetrics.stringWidth("AAAAAAAAAAAA");
    }

    public BufferedImage exportAsImage(int width, Color bgColor, Color fgColor) {
        Graphics g;
        BufferedImage imageItem;
        int lengthQuery;
        int lengthOut;
        int offsetOut;
        ImageVector imageVector = new ImageVector();
        int startQuery = Integer.parseInt((String)ReadWriteConfiguration.get("NUMBERING_OFFSET"));
        int cols = this.getPartialImageCols(width);
        String referenceString = this.finalResultItem.getOut1();
        int localWidth = width;
        int localHeight = this.getPartialImageHeight();
        int pieces = this.finalResultItem.getOutTotalLength() / cols;
        for (int i = 0; i < pieces; ++i) {
            offsetOut = i * cols;
            lengthOut = cols;
            lengthQuery = this.countNucleotides(referenceString, offsetOut, lengthOut);
            imageItem = new BufferedImage(localWidth, localHeight, 2);
            g = imageItem.getGraphics();
            this.paintImage(g, localWidth, localHeight, bgColor, fgColor, startQuery, lengthQuery, offsetOut, lengthOut);
            imageVector.add(imageItem);
            startQuery += lengthQuery;
        }
        int leftover = this.finalResultItem.getOutTotalLength() % cols;
        if (leftover != 0) {
            offsetOut = pieces * cols;
            lengthOut = leftover;
            lengthQuery = this.countNucleotides(referenceString, offsetOut, leftover);
            imageItem = new BufferedImage(localWidth, localHeight, 2);
            g = imageItem.getGraphics();
            this.paintImage(g, localWidth, localHeight, bgColor, fgColor, startQuery, lengthQuery, offsetOut, lengthOut);
            imageVector.add(imageItem);
        }
        BufferedImage resultImage = ImageManipulation.joinImages(imageVector);
        return resultImage;
    }

    public void paintImage(Graphics g, int width, int height, Color bgColor, Color fgColor, int startQuery, int lengthQuery, int startOut, int lengthOut) {
        Graphics2D g2d = (Graphics2D)g;
        int indexWidth = 0;
        g2d.setFont(this.monospaceFont_report);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        FontMetrics fontMetrics = g2d.getFontMetrics();
        int lineHeight = fontMetrics.getHeight();
        int charWidth = fontMetrics.charWidth('G');
        String queryLeftEnd = "  " + startQuery + "  ";
        int rightEnd = startQuery + lengthQuery - 1;
        String queryRightEnd = "  " + rightEnd + "  ";
        int leftTextLength = 8 * charWidth;
        int rigthTextLength = 8 * charWidth;
        String stringOut1 = this.finalResultItem.getOut1().substring(startOut, startOut + lengthOut);
        String stringRelation = this.finalResultItem.getRelation().substring(startOut, startOut + lengthOut);
        String stringOut2 = this.finalResultItem.getOut2().substring(startOut, startOut + lengthOut);
        int centerTextOffset = 2;
        int centerTextLength = fontMetrics.stringWidth(stringOut1);
        Iterator intervale = this.finalResultItem.getIntervalMappingSet().iterator();
        Color colorIntervalBorder = DrawingConstants.COLOR_CHENAR_BORDER;
        Color colorIntervalFill = DrawingConstants.COLOR_CHENAR_FILL;
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.setColor(bgColor);
        g2d.fillRect(0, 0, width, height);
        int localX = 0;
        int localY = 10 + 3 * lineHeight;
        g2d.setColor(colorIntervalBorder);
        g2d.drawString(queryLeftEnd, localX, localY);
        localX = leftTextLength + centerTextLength;
        localY = 10 + 3 * lineHeight;
        g2d.setColor(colorIntervalBorder);
        g2d.drawString(queryRightEnd, localX, localY);
        int indexInterval = 1;
        while (intervale.hasNext()) {
            String auxString;
            int sumInt;
            int localHeight;
            int localWidth;
            boolean drawRightMarker;
            boolean drawLeftMarker;
            IntervalMappingItem intervalMappingItem = (IntervalMappingItem)intervale.next();
            int markerDeviationLeft = intervalMappingItem.getPozitieStartQuery() != startQuery ? centerTextOffset : 0;
            int markerDeviationRight = intervalMappingItem.getPozitieStartQuery() + intervalMappingItem.getLengthQuery() != startQuery + lengthQuery ? centerTextOffset : 2 * centerTextOffset;
            int auxInt = intervalMappingItem.getOutStringOffset() - startOut;
            int markerLeft = (int)((double)auxInt / (double)lengthOut * (double)centerTextLength);
            if (markerLeft >= 0 && markerLeft < centerTextLength) {
                drawLeftMarker = true;
            } else {
                drawLeftMarker = false;
                if (markerLeft < 0) {
                    markerLeft = 0;
                }
                if (markerLeft >= centerTextLength) {
                    markerLeft = centerTextLength;
                }
            }
            int intervalLeft = markerLeft + leftTextLength + markerDeviationLeft;
            auxInt = intervalMappingItem.getOutStringOffset() - startOut + intervalMappingItem.getOutStringLength();
            int markerRight = (int)((double)auxInt / (double)lengthOut * (double)centerTextLength);
            if (markerRight > 0 && markerRight <= centerTextLength) {
                drawRightMarker = true;
            } else {
                drawRightMarker = false;
                if (markerRight <= 0) {
                    markerRight = 0;
                }
                if (markerRight > centerTextLength) {
                    markerRight = centerTextLength;
                }
            }
            int intervalRight = markerRight + leftTextLength + markerDeviationRight;
            int intervalWidth = intervalRight - intervalLeft;
            boolean drawInterval = markerLeft != markerRight;
            boolean drawIndexInterval = markerRight - markerLeft > 4 * charWidth;
            String textIndexInterval = "[" + indexInterval + "] " + intervalMappingItem.getFisierOrigine();
            indexWidth = fontMetrics.stringWidth(textIndexInterval);
            if (indexWidth > intervalWidth) {
                textIndexInterval = "[" + indexInterval + "]";
                indexWidth = fontMetrics.stringWidth(textIndexInterval);
            }
            ++indexInterval;
            if (intervalMappingItem.isTransposon()) {
                colorIntervalBorder = DrawingConstants.COLOR_TRANSPOSON_BORDER;
                colorIntervalFill = DrawingConstants.COLOR_TRANSPOSON_FILL;
            } else {
                colorIntervalBorder = DrawingConstants.COLOR_GENOM_BORDER;
                colorIntervalFill = DrawingConstants.COLOR_GENOM_FILL;
            }
            if (drawInterval) {
                g2d.setStroke(new BasicStroke(1.0f));
                localX = intervalLeft;
                localY = 10 + lineHeight;
                localWidth = intervalWidth;
                localHeight = 3 * lineHeight;
                g2d.setColor(colorIntervalFill);
                g2d.fillRoundRect(localX, localY, localWidth, localHeight, 5, 5);
                g2d.setColor(colorIntervalBorder);
                g2d.drawRoundRect(localX, localY, localWidth, localHeight, 5, 5);
                g2d.setStroke(new BasicStroke(2.0f));
            }
            if (intervalWidth - 8 > 25) {
                auxInt = (intervalWidth - 25) / 2;
                localX = intervalLeft + auxInt;
                localY = 10 + 2 * lineHeight + lineHeight / 2;
                localWidth = 25;
                localHeight = 0;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(colorIntervalBorder);
                g2d.drawLine(localX, localY, localX + localWidth, localY + localHeight);
                auxInt = lineHeight / 2 - 4;
                if (intervalMappingItem.isComplement()) {
                    g2d.drawLine(localX -= 2, localY, localX + auxInt, localY - auxInt);
                    g2d.drawLine(localX, localY, localX + auxInt, localY + auxInt);
                } else {
                    localX = localX + localWidth + 2;
                    g2d.drawLine(localX, localY, localX - auxInt, localY - auxInt);
                    g2d.drawLine(localX, localY, localX - auxInt, localY + auxInt);
                }
            }
            if (drawIndexInterval) {
                Font oldFont = g2d.getFont();
                g2d.setFont(oldFont.deriveFont(1, oldFont.getSize() + 1));
                localX = intervalLeft + intervalWidth / 2 - indexWidth / 2;
                localY = 10 + 5 * lineHeight;
                g2d.setColor(colorIntervalBorder);
                g2d.drawString(textIndexInterval, localX, localY);
                g2d.setFont(oldFont);
            }
            int textMarkerWidth = 4;
            int textMarkerHeight = 6;
            if (drawLeftMarker) {
                localX = intervalLeft;
                localY = 10 + lineHeight;
                g2d.setColor(colorIntervalBorder);
                g2d.setStroke(new BasicStroke(1.0f));
                g2d.drawLine(localX, localY, localX, localY - textMarkerHeight);
                localX = intervalLeft;
                localY = 10 + lineHeight - textMarkerHeight;
                g2d.setColor(colorIntervalBorder);
                g2d.drawLine(localX, localY, localX + textMarkerWidth, localY);
            }
            if (drawRightMarker) {
                localX = intervalRight;
                localY = 10 + lineHeight;
                g2d.setColor(colorIntervalBorder);
                g2d.setStroke(new BasicStroke(1.0f));
                g2d.drawLine(localX, localY, localX, localY - textMarkerHeight);
                localX = intervalRight;
                localY = 10 + lineHeight - textMarkerHeight;
                g2d.setColor(colorIntervalBorder);
                g2d.drawLine(localX, localY, localX - textMarkerWidth, localY);
                g2d.setStroke(new BasicStroke(2.0f));
            }
            textMarkerWidth = 4;
            textMarkerHeight = 6;
            if (drawLeftMarker) {
                localX = intervalLeft;
                localY = 10 + 4 * lineHeight;
                g2d.setColor(colorIntervalBorder);
                g2d.setStroke(new BasicStroke(1.0f));
                g2d.drawLine(localX, localY, localX, localY + textMarkerHeight);
                localX = intervalLeft;
                localY = 10 + 4 * lineHeight + textMarkerHeight;
                g2d.setColor(colorIntervalBorder);
                g2d.drawLine(localX, localY, localX + textMarkerWidth, localY);
            }
            if (drawRightMarker) {
                localX = intervalRight;
                localY = 10 + 4 * lineHeight;
                g2d.setColor(colorIntervalBorder);
                g2d.setStroke(new BasicStroke(1.0f));
                g2d.drawLine(localX, localY, localX, localY + textMarkerHeight);
                localX = intervalRight;
                localY = 10 + 4 * lineHeight + textMarkerHeight;
                g2d.setColor(colorIntervalBorder);
                g2d.drawLine(localX, localY, localX - textMarkerWidth, localY);
                g2d.setStroke(new BasicStroke(2.0f));
            }
            textMarkerWidth = 6;
            if (drawLeftMarker && (sumInt = (auxInt = fontMetrics.stringWidth(auxString = intervalMappingItem.getPozitieStartQuery() + "")) + 2 * textMarkerWidth) < intervalWidth) {
                localX = intervalLeft + textMarkerWidth;
                localY = 10 + lineHeight - 5;
                g2d.setColor(colorIntervalBorder);
                g2d.drawString(intervalMappingItem.getPozitieStartQuery() + "", localX, localY);
            }
            if (drawRightMarker) {
                auxString = intervalMappingItem.getPozitieStopQuery() + "";
                sumInt = auxInt;
                auxInt = fontMetrics.stringWidth(auxString);
                if ((sumInt += auxInt + 2 * textMarkerWidth + 8) < intervalWidth) {
                    localX = intervalRight - auxInt - textMarkerWidth;
                    localY = 10 + lineHeight - 5;
                    g2d.setColor(colorIntervalBorder);
                    g2d.drawString(auxString, localX, localY);
                }
            }
            textMarkerWidth = 6;
            if (drawLeftMarker && (sumInt = (auxInt = fontMetrics.stringWidth(auxString = intervalMappingItem.getPozitieStartGenom() + "")) + textMarkerWidth + indexWidth / 2) < intervalWidth / 2) {
                localX = intervalLeft + textMarkerWidth;
                localY = 10 + 5 * lineHeight;
                g2d.setColor(colorIntervalBorder);
                g2d.drawString(auxString, localX, localY);
            }
            if (!drawRightMarker) continue;
            auxString = intervalMappingItem.getPozitieStopGenom() + "";
            sumInt = auxInt;
            auxInt = fontMetrics.stringWidth(auxString);
            if ((sumInt += auxInt + 2 * textMarkerWidth + 8 + indexWidth) >= intervalWidth) continue;
            localX = intervalRight - auxInt - textMarkerWidth;
            localY = 10 + 5 * lineHeight;
            g2d.setColor(colorIntervalBorder);
            g2d.drawString(auxString, localX, localY);
        }
        localX = leftTextLength + centerTextOffset;
        localY = 10 + 2 * lineHeight - centerTextOffset;
        g2d.setColor(fgColor);
        g2d.drawString(stringOut1, localX, localY);
        localX = leftTextLength + centerTextOffset;
        localY = 10 + 3 * lineHeight - centerTextOffset;
        g2d.setColor(fgColor);
        g2d.drawString(stringRelation, localX, localY);
        localX = leftTextLength + centerTextOffset;
        localY = 10 + 4 * lineHeight - centerTextOffset;
        g2d.setColor(fgColor);
        g2d.drawString(stringOut2, localX, localY);
    }

    private int getPartialImageHeight() {
        BufferedImage phonyImage = new BufferedImage(1, 1, 2);
        Graphics2D g2d = (Graphics2D)phonyImage.getGraphics();
        g2d.setFont(this.monospaceFont_gui);
        FontMetrics fontMetrics = g2d.getFontMetrics();
        int lineHeight = fontMetrics.getHeight();
        int recommendedSize = 10 + 5 * lineHeight;
        return recommendedSize;
    }

    private int getPartialImageCols(int width) {
        BufferedImage phonyImage = new BufferedImage(1, 1, 2);
        Graphics2D g2d = (Graphics2D)phonyImage.getGraphics();
        g2d.setFont(this.monospaceFont_report);
        FontMetrics fontMetrics = g2d.getFontMetrics();
        int charWidth = fontMetrics.charWidth('G');
        int recommendedCols = width / charWidth - 8 - 8;
        return recommendedCols;
    }

    public int countNucleotides(String outString, int offset, int length) {
        int matches = 0;
        for (int i = offset; i < offset + length; ++i) {
            if (!DNAUtils.isNucleotide(outString.charAt(i))) continue;
            ++matches;
        }
        return matches;
    }
}

