/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.controller.finalresult;

import javax.swing.JComponent;
import ro.genomeartist.gui.controller.finalresult.IntervalMappingSet;
import ro.genomeartist.gui.controller.genes.GeneItem;
import ro.genomeartist.gui.controller.genes.GeneItemWrapper;
import ro.genomeartist.gui.controller.genes.GeneVector;
import ro.genomeartist.gui.utils.ReadWriteConfiguration;

public class IntervalMappingItem {
    private String fisierOrigine;
    public int pozitieQuery;
    public int pozitieGenom;
    public int lengthQuery;
    public int lengthGenom;
    public int lengthInitialQuery;
    private GeneItem closestUpstream;
    private GeneItem closestDownstream;
    private GeneVector insideGenes;
    private int outStringOffset;
    private int outStringLength;
    private int outStringTotalLength;
    private boolean isComplement;
    private boolean isTransposon;
    private IntervalMappingSet mappingParinte;
    private int offset;
    private GeneItemWrapper geneItemWrapper;

    public IntervalMappingItem() {
        this(new IntervalMappingSet());
    }

    public IntervalMappingItem(IntervalMappingSet mappingParinte) {
        this.mappingParinte = mappingParinte;
        this.offset = Integer.parseInt((String)ReadWriteConfiguration.get("NUMBERING_OFFSET"));
        this.insideGenes = new GeneVector();
        this.geneItemWrapper = new GeneItemWrapper(mappingParinte, this);
    }

    public GeneItem getClosestDownstream() {
        return this.closestDownstream;
    }

    public void setClosestDownstream(GeneItem closestDownstream) {
        this.closestDownstream = closestDownstream;
    }

    public GeneItem getClosestUpstream() {
        return this.closestUpstream;
    }

    public void setClosestUpstream(GeneItem closestUpstream) {
        this.closestUpstream = closestUpstream;
    }

    public String getFisierOrigine() {
        return this.fisierOrigine;
    }

    public void setFisierOrigine(String fisierOrigine) {
        this.fisierOrigine = fisierOrigine;
    }

    public GeneVector getInsideGenes() {
        return this.insideGenes;
    }

    public void addInsideGene(GeneItem insideGene) {
        this.insideGenes.add(insideGene);
    }

    public void pushInsideGene(GeneItem insideGene) {
        this.insideGenes.insertElementAt(insideGene, 0);
    }

    public GeneItemWrapper getGeneItemWrapper() {
        return this.geneItemWrapper;
    }

    public void setGeneItemWrapper(GeneItemWrapper geneItemWrapper) {
        this.geneItemWrapper = geneItemWrapper;
    }

    public boolean isComplement() {
        return this.isComplement;
    }

    public void setIsComplement(boolean isComplement) {
        this.isComplement = isComplement;
    }

    public boolean isTransposon() {
        return this.isTransposon;
    }

    public void setIsTransposon(boolean isTransposon) {
        this.isTransposon = isTransposon;
    }

    public int getLengthGenom() {
        return this.lengthGenom;
    }

    public void setLengthGenom(int lengthGenom) {
        this.lengthGenom = lengthGenom;
    }

    public int getLengthInitialQuery() {
        return this.lengthInitialQuery;
    }

    public void setLengthInitialQuery(int lengthInitialQuery) {
        this.lengthInitialQuery = lengthInitialQuery;
    }

    public int getLengthQuery() {
        return this.lengthQuery;
    }

    public void setLengthQuery(int lengthQuery) {
        this.lengthQuery = lengthQuery;
    }

    public int getOutStringLength() {
        return this.outStringLength;
    }

    public void setOutStringLength(int outStringLength) {
        this.outStringLength = outStringLength;
    }

    public int getOutStringOffset() {
        return this.outStringOffset;
    }

    public void setOutStringOffset(int outStringOffset) {
        this.outStringOffset = outStringOffset;
    }

    public int getOutStringTotalLength() {
        return this.outStringTotalLength;
    }

    public void setOutStringTotalLength(int outStringTotalLength) {
        this.outStringTotalLength = outStringTotalLength;
    }

    public int getPozitieStartGenom() {
        if (this.isComplement) {
            return this.pozitieGenom + this.offset + this.lengthGenom - 1;
        }
        return this.pozitieGenom + this.offset;
    }

    public void setPozitieStartGenom(int pozitieGenom) {
        this.pozitieGenom = pozitieGenom;
    }

    public int getPozitieStartQuery() {
        return this.pozitieQuery + this.offset;
    }

    public void setPozitieQuery(int pozitieQuery) {
        this.pozitieQuery = pozitieQuery;
    }

    public int getPozitieStopQuery() {
        return this.pozitieQuery + this.offset + this.lengthQuery - 1;
    }

    public int getPozitieStopGenom() {
        if (this.isComplement) {
            return this.pozitieGenom + this.offset;
        }
        return this.pozitieGenom + this.offset + this.lengthGenom - 1;
    }

    public int getRecommendedHeight(JComponent component) {
        return this.geneItemWrapper.getAltRecommendedHeight(component);
    }

    public int getRecommendedWidth(JComponent component) {
        return this.geneItemWrapper.getAltRecommendedWidth(component);
    }

    public int getIntervalIndex() {
        if (this.mappingParinte != null) {
            return this.mappingParinte.indexOf(this);
        }
        return -1;
    }
}

