/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.controller.partialresult;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.UIManager;
import ro.genomeartist.gui.custompaint.DrawingConstants;
import ro.genomeartist.gui.interfaces.ICanPaint;
import ro.genomeartist.gui.utils.ReadWriteConfiguration;

public class PartialResultItem
implements Comparable,
ICanPaint {
    private String fisierOrigine;
    private int pozitieQuery;
    private int pozitieGenom;
    private int lengthQuery;
    private int lengthGenom;
    private int length;
    private int score;
    private String out1;
    private String relation;
    private String out2;
    private boolean isComplement;
    private boolean isTransposon;
    private int lengthInitialQuery;
    private int offset = Integer.parseInt((String)ReadWriteConfiguration.get("NUMBERING_OFFSET"));

    public void paint(Graphics g, int width, int height, Color bgColor, Color fgColor) {
        int auxInt;
        Color colorIntervalFill;
        Color colorIntervalBorder;
        Graphics2D g2d = (Graphics2D)g;
        FontMetrics fontMetrics = g2d.getFontMetrics();
        int lineHeight = fontMetrics.getHeight();
        String leftEnd = new String(" " + this.offset + " ");
        int auxRightEnd = this.offset + this.getLengthInitialQuery() - 1;
        String rightEnd = new String(" " + auxRightEnd + " ");
        int leftTextLength = fontMetrics.stringWidth(leftEnd);
        int rigthTextLength = fontMetrics.stringWidth(rightEnd);
        int chenarWidth = width - 10 - 10 - leftTextLength - rigthTextLength;
        int markerLeft = (int)((double)this.pozitieQuery / (double)this.getLengthInitialQuery() * (double)chenarWidth);
        int intervalLeft = 10 + markerLeft + leftTextLength;
        int markerRight = (int)((double)(this.pozitieQuery + this.getLengthQuery()) / (double)this.getLengthInitialQuery() * (double)chenarWidth);
        int intervalRight = 10 + markerRight + leftTextLength;
        int intervalWidth = intervalRight - intervalLeft;
        if (this.isTransposon) {
            colorIntervalBorder = DrawingConstants.COLOR_TRANSPOSON_BORDER;
            colorIntervalFill = DrawingConstants.COLOR_TRANSPOSON_FILL;
        } else {
            colorIntervalBorder = DrawingConstants.COLOR_GENOM_BORDER;
            colorIntervalFill = DrawingConstants.COLOR_GENOM_FILL;
        }
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.setColor(bgColor);
        g2d.fillRect(0, 0, width, height);
        int localX = 10 + leftTextLength;
        int localY = 10 + lineHeight;
        int localWidth = chenarWidth;
        int localHeight = lineHeight;
        g2d.setColor(DrawingConstants.COLOR_CHENAR_FILL);
        g2d.fillRoundRect(localX, localY, localWidth, localHeight, 5, 5);
        g2d.setColor(DrawingConstants.COLOR_CHENAR_BORDER);
        g2d.drawRoundRect(localX, localY, localWidth, localHeight, 5, 5);
        localX = 10;
        localY = 10 + 2 * lineHeight - 5;
        g2d.setColor(fgColor);
        g2d.drawString(leftEnd, localX, localY);
        localX = width - 10 - rigthTextLength;
        localY = 10 + 2 * lineHeight - 5;
        g2d.setColor(fgColor);
        g2d.drawString(rightEnd, localX, localY);
        localX = intervalLeft;
        localY = 10 + lineHeight;
        localWidth = intervalWidth;
        localHeight = lineHeight;
        g2d.setColor(colorIntervalFill);
        g2d.fillRoundRect(localX, localY, localWidth, localHeight, 5, 5);
        g2d.setColor(colorIntervalBorder);
        g2d.drawRoundRect(localX, localY, localWidth, localHeight, 5, 5);
        localX = intervalLeft;
        localY = 10 + lineHeight;
        localWidth = intervalRight - intervalLeft;
        localHeight = lineHeight;
        g2d.setColor(colorIntervalFill);
        g2d.fillRoundRect(localX, localY, localWidth, localHeight, 5, 5);
        g2d.setColor(colorIntervalBorder);
        g2d.drawRoundRect(localX, localY, localWidth, localHeight, 5, 5);
        if (intervalWidth - 8 > 25) {
            auxInt = (intervalWidth - 25) / 2;
            localX = intervalLeft + auxInt;
            localY = 10 + lineHeight + lineHeight / 2;
            localWidth = 25;
            localHeight = 0;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(colorIntervalBorder);
            g2d.drawLine(localX, localY, localX + localWidth, localY + localHeight);
            auxInt = lineHeight / 2 - 4;
            if (this.isComplement) {
                g2d.drawLine(localX -= 2, localY, localX + auxInt, localY - auxInt);
                g2d.drawLine(localX, localY, localX + auxInt, localY + auxInt);
            } else {
                localX = localX + localWidth + 2;
                g2d.drawLine(localX, localY, localX - auxInt, localY - auxInt);
                g2d.drawLine(localX, localY, localX - auxInt, localY + auxInt);
            }
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }
        String auxString = this.getPozitieStartQuery() + "";
        auxInt = fontMetrics.stringWidth(auxString);
        int stringHalf = auxInt / 2;
        localX = intervalLeft - stringHalf;
        localY = 10 + lineHeight - 5;
        g2d.setColor(colorIntervalBorder);
        g2d.drawString(auxString, localX, localY);
        auxString = this.getPozitieStopQuery() + "";
        auxInt = fontMetrics.stringWidth(auxString);
        if (auxInt < intervalWidth) {
            stringHalf = auxInt / 2;
            localX = intervalRight - stringHalf;
            localY = 10 + lineHeight - 5;
            g2d.setColor(colorIntervalBorder);
            g2d.drawString(auxString, localX, localY);
        }
        auxString = this.getPozitieStartGenom() + "";
        auxInt = fontMetrics.stringWidth(auxString);
        stringHalf = auxInt / 2;
        localX = intervalLeft - stringHalf;
        localY = 10 + 3 * lineHeight;
        g2d.setColor(colorIntervalBorder);
        g2d.drawString(auxString, localX, localY);
        auxString = this.getPozitieStopGenom() + "";
        auxInt = fontMetrics.stringWidth(auxString);
        if (auxInt < intervalWidth) {
            stringHalf = auxInt / 2;
            localX = intervalRight - stringHalf;
            localY = 10 + 3 * lineHeight;
            g2d.setColor(colorIntervalBorder);
            g2d.drawString(auxString, localX, localY);
        }
    }

    public int getRecommendedHeight(JComponent component) {
        Font font = UIManager.getDefaults().getFont("Table.font");
        int lineHeight = component.getFontMetrics(font).getHeight();
        int recommendedSize = 20 + 3 * lineHeight;
        return recommendedSize;
    }

    public int getRecommendedWidth(JComponent component) {
        return 300;
    }

    public int compareTo(Object o) {
        if (o instanceof PartialResultItem) {
            PartialResultItem resultItem = (PartialResultItem)o;
            return this.getPozitieStartQuery() - resultItem.getPozitieStartQuery();
        }
        throw new ClassCastException("Cannot compare");
    }

    public String getFisierOrigine() {
        return this.fisierOrigine;
    }

    public void setFisierOrigine(String fisierOrigine) {
        this.fisierOrigine = fisierOrigine;
    }

    public boolean isComplement() {
        return this.isComplement;
    }

    public void setIsComplement(boolean isComplement) {
        this.isComplement = isComplement;
    }

    public boolean isTransposon() {
        return this.isTransposon;
    }

    public void setIsTransposon(boolean isTransposon) {
        this.isTransposon = isTransposon;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getLengthGenom() {
        return this.lengthGenom;
    }

    public void setLengthGenom(int lengthGenom) {
        this.lengthGenom = lengthGenom;
    }

    public int getLengthInitialQuery() {
        return this.lengthInitialQuery;
    }

    public void setLengthInitialQuery(int lengthInitialQuery) {
        this.lengthInitialQuery = lengthInitialQuery;
    }

    public int getLengthQuery() {
        return this.lengthQuery;
    }

    public void setLengthQuery(int lengthQuery) {
        this.lengthQuery = lengthQuery;
    }

    public String getOut1() {
        return this.out1;
    }

    public void setOut1(String out1) {
        this.out1 = out1;
    }

    public String getOut2() {
        return this.out2;
    }

    public void setOut2(String out2) {
        this.out2 = out2;
    }

    public int getPozitieStartGenom() {
        if (this.isComplement) {
            return this.pozitieGenom + this.offset + this.lengthGenom - 1;
        }
        return this.pozitieGenom + this.offset;
    }

    public void setPozitieStartGenom(int pozitieGenom) {
        this.pozitieGenom = pozitieGenom;
    }

    public int getPozitieStartQuery() {
        return this.pozitieQuery + this.offset;
    }

    public void setPozitieStartQuery(int pozitieQuery) {
        this.pozitieQuery = pozitieQuery;
    }

    public int getPozitieStopQuery() {
        return this.pozitieQuery + this.offset + this.lengthQuery - 1;
    }

    public int getPozitieStopGenom() {
        if (this.isComplement) {
            return this.pozitieGenom + this.offset;
        }
        return this.pozitieGenom + this.offset + this.lengthGenom - 1;
    }

    public String getRelation() {
        return this.relation;
    }

    public void setRelation(String relation) {
        this.relation = relation;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }
}

