/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.controller.partialresult;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.UIManager;
import ro.genomeartist.gui.controller.partialresult.PartialResultItem;
import ro.genomeartist.gui.custompaint.DrawingConstants;
import ro.genomeartist.gui.interfaces.ICanPaint;

public class PartialResultItemAlignment
implements ICanPaint {
    private PartialResultItem partialResultItem;
    private Font monospaceFont;

    public PartialResultItemAlignment(PartialResultItem partialResultItem) {
        this.partialResultItem = partialResultItem;
        Font font = UIManager.getDefaults().getFont("Table.font");
        this.monospaceFont = new Font("Monospaced", 0, font.getSize());
    }

    public void paint(Graphics g, int width, int height, Color bgColor, Color fgColor) {
        Color colorIntervalBorder;
        Graphics2D g2d = (Graphics2D)g;
        g2d.setFont(this.monospaceFont);
        FontMetrics fontMetrics = g2d.getFontMetrics();
        int lineHeight = fontMetrics.getHeight();
        String queryLeftEnd = " " + this.partialResultItem.getPozitieStartQuery() + " ";
        String queryRightEnd = " " + this.partialResultItem.getPozitieStopQuery() + " ";
        String genomLeftEnd = " " + this.partialResultItem.getPozitieStartGenom() + " ";
        String genomRightEnd = " " + this.partialResultItem.getPozitieStopGenom() + " ";
        int leftTextLength = fontMetrics.stringWidth(queryLeftEnd);
        int auxInt = fontMetrics.stringWidth(genomLeftEnd);
        if (auxInt > leftTextLength) {
            leftTextLength = auxInt;
        }
        int rigthTextLength = fontMetrics.stringWidth(queryRightEnd);
        auxInt = fontMetrics.stringWidth(genomRightEnd);
        if (auxInt > rigthTextLength) {
            rigthTextLength = auxInt;
        }
        int centerTextLength = fontMetrics.stringWidth(this.partialResultItem.getOut1());
        if (this.partialResultItem.isTransposon()) {
            colorIntervalBorder = DrawingConstants.COLOR_TRANSPOSON_BORDER;
            Color colorIntervalFill = DrawingConstants.COLOR_TRANSPOSON_FILL;
        } else {
            colorIntervalBorder = DrawingConstants.COLOR_GENOM_BORDER;
            Color colorIntervalFill = DrawingConstants.COLOR_GENOM_FILL;
        }
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.setColor(bgColor);
        g2d.fillRect(0, 0, width, height);
        int localX = 10;
        int localY = 10 + lineHeight;
        g2d.setColor(colorIntervalBorder);
        g2d.drawString(queryLeftEnd, localX, localY);
        localX = 10 + leftTextLength + centerTextLength;
        localY = 10 + lineHeight;
        g2d.setColor(colorIntervalBorder);
        g2d.drawString(queryRightEnd, localX, localY);
        localX = 10;
        localY = 10 + 3 * lineHeight;
        g2d.setColor(colorIntervalBorder);
        g2d.drawString(genomLeftEnd, localX, localY);
        localX = 10 + leftTextLength + centerTextLength;
        localY = 10 + 3 * lineHeight;
        g2d.setColor(colorIntervalBorder);
        g2d.drawString(genomRightEnd, localX, localY);
        localX = 10 + leftTextLength;
        localY = 10 + lineHeight;
        g2d.setColor(fgColor);
        g2d.drawString(this.partialResultItem.getOut1(), localX, localY);
        localX = 10 + leftTextLength;
        localY = 10 + 2 * lineHeight;
        g2d.setColor(fgColor);
        g2d.drawString(this.partialResultItem.getRelation(), localX, localY);
        localX = 10 + leftTextLength;
        localY = 10 + 3 * lineHeight;
        g2d.setColor(fgColor);
        g2d.drawString(this.partialResultItem.getOut2(), localX, localY);
    }

    public int getRecommendedHeight(JComponent component) {
        int lineHeight = component.getFontMetrics(this.monospaceFont).getHeight();
        int recommendedSize = 20 + 5 * lineHeight;
        return recommendedSize;
    }

    public int getRecommendedWidth(JComponent component) {
        FontMetrics fontMetrics = component.getFontMetrics(this.monospaceFont);
        int recommendedSize = fontMetrics.stringWidth(this.partialResultItem.getOut1());
        return recommendedSize += 20 + 2 * fontMetrics.stringWidth("AAAAAAAAAAAA");
    }
}

