/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.custompaint;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.UIManager;
import ro.genomeartist.gui.interfaces.ICanPaint;

public class BoldInteger
implements Comparable,
ICanPaint {
    private static final int FONT_OFFSET = 2;
    private static final int LINEWIDTH = 2;
    private static final int RECOMMENDED_WIDTH = 300;
    private int integer;

    public BoldInteger(int integer) {
        this.integer = integer;
    }

    public int getInteger() {
        return this.integer;
    }

    public void paint(Graphics g, int width, int height, Color bgColor, Color fgColor) {
        Graphics2D g2d = (Graphics2D)g;
        Font oldFont = g2d.getFont();
        int oldFontSize = oldFont.getSize();
        g2d.setFont(oldFont.deriveFont(1, oldFontSize + 2));
        FontMetrics fontMetrics = g2d.getFontMetrics();
        String text = this.integer + "";
        int textHeight = fontMetrics.getHeight();
        int textWidth = fontMetrics.stringWidth(text);
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.setColor(bgColor);
        g2d.fillRect(0, 0, width, height);
        int localX = (width - textWidth) / 2;
        int localY = (height + textHeight) / 2;
        g2d.setColor(fgColor);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.drawString(text, localX, localY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    }

    public int getRecommendedHeight(JComponent component) {
        int lineHeight;
        Font font = UIManager.getDefaults().getFont("Table.font");
        int recommendedSize = lineHeight = component.getFontMetrics(font).getHeight();
        return recommendedSize;
    }

    public int getRecommendedWidth(JComponent component) {
        return 300;
    }

    public int compareTo(Object o) {
        if (o instanceof BoldInteger) {
            BoldInteger boldInteger = (BoldInteger)o;
            return this.integer - boldInteger.getInteger();
        }
        throw new ClassCastException("Cannot compare");
    }
}

