/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ro.genomeartist.gui.controller.settings.SearchFolder;
import ro.genomeartist.gui.interfaces.IGlobalManager;
import ro.genomeartist.gui.utils.JMyBoolean;
import ro.genomeartist.gui.utils.MyUtils;
import ro.genomeartist.gui.utils.StringUtils;

public class JAddFolderDialog
extends JDialog {
    private IGlobalManager globalManager;
    private SearchFolder searchFolderRaw;
    private JMyBoolean isOk;
    private static final String TITLE_FILE = "File information";
    private static final String TEXT_NAME = "Name*";
    private static final String TEXT_SEQUENCE_LOCATION = "Folder with raw sequences*";
    private static final String TEXT_HINT = "* required fields";
    private static final int FRAME_WIDTH = 500;
    private static final int FRAME_HEIGHT = 200;
    private static final int TEXTFIELD_LENGTH = 10;
    private static final int LABEL_SIZE = 200;
    private static final int HUGE_SIZE = 3000;
    private static final String BUTTON_FOLDER = "...";
    private static final String BUTTON_OK = "    Ok    ";
    private static final String BUTTON_CANCEL = "  Cancel  ";
    private static final String ACTION_FOLDER = "seq_file";
    private static final String ACTION_OK = "ok";
    private static final String ACTION_CANCEL = "apply";
    private JPanel middlePane;
    private JPanel namePanel;
    private JLabel labelTextName;
    private JTextField textfieldName;
    private JPanel folderPanel;
    private JLabel labelTextFolder;
    private JTextField textfieldFolder;
    private JButton buttonFolderFile;
    private JPanel hintPanel;
    private JLabel labelTextHint;
    private JPanel bottomPane;
    private JButton buttonOk;
    private JButton buttonCancel;
    private JFileChooser fc;
    ActionListener buttonListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (JAddFolderDialog.ACTION_FOLDER.equals(cmd)) {
                int returnVal = JAddFolderDialog.this.fc.showOpenDialog(JAddFolderDialog.this.globalManager.getTheRootFrame());
                if (returnVal == 0) {
                    ((JAddFolderDialog)JAddFolderDialog.this).searchFolderRaw.folderLocation = JAddFolderDialog.this.fc.getSelectedFile();
                    JAddFolderDialog.this.updatePanelFromRaw();
                }
            } else if (JAddFolderDialog.ACTION_OK.equals(cmd)) {
                String auxString = JAddFolderDialog.this.textfieldName.getText();
                if (auxString.isEmpty()) {
                    auxString = "file";
                }
                ((JAddFolderDialog)JAddFolderDialog.this).searchFolderRaw.fileTitle = StringUtils.sanitizeFilename(auxString);
                JAddFolderDialog.this.isOk.setTrue();
                JAddFolderDialog.this.dispose();
            } else if (JAddFolderDialog.ACTION_CANCEL.equals(cmd)) {
                JAddFolderDialog.this.isOk.setFalse();
                JAddFolderDialog.this.dispose();
            }
        }
    };

    public JAddFolderDialog(IGlobalManager globalManager, String title, boolean modal, JMyBoolean isOk) {
        super(globalManager.getTheRootFrame(), title, modal);
        this.setSize(500, 200);
        this.globalManager = globalManager;
        this.searchFolderRaw = new SearchFolder();
        this.isOk = isOk;
        this.fc = new JFileChooser();
        this.fc.setFileSelectionMode(1);
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
        this.setLayout(new BorderLayout());
        this.middlePane = this.createMiddlePane();
        this.add((Component)this.middlePane, "Center");
        this.bottomPane = new JPanel();
        this.bottomPane.setLayout(new BoxLayout(this.bottomPane, 0));
        this.bottomPane.add(Box.createHorizontalGlue());
        this.buttonOk = new JButton(BUTTON_OK);
        this.buttonOk.setActionCommand(ACTION_OK);
        this.buttonOk.addActionListener(this.buttonListener);
        this.bottomPane.add(this.buttonOk);
        this.buttonCancel = new JButton(BUTTON_CANCEL);
        this.buttonCancel.setActionCommand(ACTION_CANCEL);
        this.buttonCancel.addActionListener(this.buttonListener);
        this.bottomPane.add(this.buttonCancel);
        this.bottomPane.add(Box.createHorizontalGlue());
        this.add((Component)this.bottomPane, "South");
        this.setLocationRelativeTo(globalManager.getTheRootFrame());
    }

    private JPanel createMiddlePane() {
        JPanel localPane = new JPanel();
        localPane.setLayout(new BoxLayout(localPane, 1));
        localPane.setBorder(BorderFactory.createTitledBorder(TITLE_FILE));
        this.labelTextName = new JLabel(TEXT_NAME);
        this.textfieldName = new JTextField(10);
        this.textfieldName.setText("name");
        this.namePanel = this.createAlignedPane(this.labelTextName, this.textfieldName, false);
        localPane.add(this.namePanel);
        this.labelTextFolder = new JLabel(TEXT_SEQUENCE_LOCATION);
        this.textfieldFolder = new JTextField(10);
        this.textfieldFolder.setEditable(false);
        this.folderPanel = this.createAlignedPane(this.labelTextFolder, this.textfieldFolder, false);
        this.buttonFolderFile = new JButton();
        this.buttonFolderFile.setText(BUTTON_FOLDER);
        this.buttonFolderFile.setActionCommand(ACTION_FOLDER);
        this.buttonFolderFile.addActionListener(this.buttonListener);
        this.folderPanel.add(this.buttonFolderFile);
        localPane.add(this.folderPanel);
        this.labelTextHint = new JLabel(TEXT_HINT);
        MyUtils.increaseLabelFont(this.labelTextHint, -2);
        this.labelTextHint.setForeground(Color.blue);
        this.hintPanel = this.createAlignedPane(this.labelTextHint, new JLabel(" "), true);
        localPane.add(this.hintPanel);
        localPane.add(Box.createVerticalStrut(3000));
        return localPane;
    }

    private JPanel createAlignedPane(JLabel label1, Component component2, boolean withGap) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        label1.setPreferredSize(new Dimension(200, 0));
        panel.add(label1);
        if (withGap) {
            panel.add(Box.createHorizontalGlue());
        }
        panel.add(component2);
        return panel;
    }

    public SearchFolder getFolderRaw() {
        return this.searchFolderRaw;
    }

    private void updatePanelFromRaw() {
        if (this.searchFolderRaw.folderLocation != null) {
            this.textfieldFolder.setText(this.searchFolderRaw.folderLocation.getPath());
            this.textfieldFolder.setToolTipText(this.searchFolderRaw.folderLocation.getPath());
        }
        this.repaint();
    }
}

