/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import ro.genomeartist.gui.controller.settings.SearchFileSequence;
import ro.genomeartist.gui.interfaces.IGlobalManager;
import ro.genomeartist.gui.popups.JTextareaPopup;
import ro.genomeartist.gui.utils.DNAUtils;
import ro.genomeartist.gui.utils.JMyBoolean;
import ro.genomeartist.gui.utils.MyUtils;
import ro.genomeartist.gui.utils.StringUtils;

public class JCreateFileDialog
extends JDialog {
    private static final int FRAME_WIDTH = 300;
    private static final int FRAME_HEIGHT = 200;
    private static final int BUTTON_WIDTH = 100;
    private static final String TEXT_TITLE = "File from sequence";
    private static final String TEXT_NAME = "Name";
    private static final String TEXT_NAME_FIELD = "sequence_001";
    private static final String TEXT_QUERY = "Sequence";
    private static final int TEXTAREA_ROWS = 10;
    private static final int TEXTAREA_COLS = 10;
    private static final int TEXTFIELD_COLS = 25;
    private static final int LABEL_SIZE = 100;
    private IGlobalManager globalManager;
    private SearchFileSequence searchFileSequence;
    private JMyBoolean isOk;
    private JPanel middlePane;
    private JPanel namePane;
    private JLabel labelTextName;
    private JTextField textfieldValueName;
    private JPanel queryLabelPane;
    private JLabel labelTextQuery;
    private JPanel queryPane;
    private JTextArea textareaValueQuery;
    private JPanel buttonPane;
    private JButton searchButton;
    private JPanel bottomPane;
    private JButton buttonOk;
    private JButton buttonCancel;
    private static final String BUTTON_OK = "    Ok    ";
    private static final String BUTTON_CANCEL = "  Cancel  ";
    private static final String ACTION_OK = "ok";
    private static final String ACTION_CANCEL = "apply";
    ActionListener buttonListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (JCreateFileDialog.ACTION_OK.equals(cmd)) {
                JCreateFileDialog.this.fireActionOk();
            } else if (JCreateFileDialog.ACTION_CANCEL.equals(cmd)) {
                JCreateFileDialog.this.fireActionCancel();
            }
        }
    };

    public JCreateFileDialog(IGlobalManager globalManager, String title, boolean modal, JMyBoolean isOk) {
        super(globalManager.getTheRootFrame(), title, modal);
        this.setSize(300, 200);
        this.globalManager = globalManager;
        this.isOk = isOk;
        this.setResizable(true);
        this.setDefaultCloseOperation(1);
        this.setLayout(new BorderLayout());
        this.middlePane = new JPanel();
        this.middlePane.setLayout(new BoxLayout(this.middlePane, 1));
        this.middlePane.setBorder(BorderFactory.createTitledBorder(TEXT_TITLE));
        this.labelTextName = new JLabel(TEXT_NAME);
        this.labelTextName.setPreferredSize(new Dimension(100, 0));
        this.textfieldValueName = new JTextField(25);
        this.textfieldValueName.setText(TEXT_NAME_FIELD);
        this.namePane = this.createAlignedPane(this.labelTextName, this.textfieldValueName);
        this.middlePane.add(this.namePane);
        this.labelTextQuery = new JLabel(TEXT_QUERY);
        MyUtils.setLabelBold(this.labelTextQuery);
        this.queryLabelPane = this.createAlignedPane(this.labelTextQuery, new JLabel(""));
        this.middlePane.add(this.queryLabelPane);
        this.textareaValueQuery = new JTextArea(10, 10);
        this.textareaValueQuery.setEditable(true);
        this.textareaValueQuery.setLineWrap(true);
        JTextareaPopup textareaPopup = new JTextareaPopup(this.textareaValueQuery, false);
        this.textareaValueQuery.addMouseListener(textareaPopup.getTextareaTrigger());
        JScrollPane scrollPane = new JScrollPane(this.textareaValueQuery);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setVerticalScrollBarPolicy(20);
        this.middlePane.add(scrollPane);
        this.add((Component)this.middlePane, "Center");
        this.bottomPane = new JPanel();
        this.bottomPane.setLayout(new BoxLayout(this.bottomPane, 0));
        this.bottomPane.add(Box.createHorizontalGlue());
        this.buttonOk = new JButton(BUTTON_OK);
        this.buttonOk.setActionCommand(ACTION_OK);
        this.buttonOk.addActionListener(this.buttonListener);
        this.bottomPane.add(this.buttonOk);
        this.buttonCancel = new JButton(BUTTON_CANCEL);
        this.buttonCancel.setActionCommand(ACTION_CANCEL);
        this.buttonCancel.addActionListener(this.buttonListener);
        this.bottomPane.add(this.buttonCancel);
        this.bottomPane.add(Box.createHorizontalGlue());
        this.add((Component)this.bottomPane, "South");
        this.pack();
        this.setLocationRelativeTo(globalManager.getTheRootFrame());
    }

    private JPanel createAlignedPane(JLabel label1, Component component2) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(label1);
        panel.add(Box.createHorizontalGlue());
        panel.add(component2);
        return panel;
    }

    public SearchFileSequence getSearchFileSequence() {
        return this.searchFileSequence;
    }

    private void fireActionOk() {
        this.searchFileSequence = new SearchFileSequence();
        this.searchFileSequence.name = StringUtils.sanitizeFilename(this.textfieldValueName.getText());
        this.searchFileSequence.sequence = DNAUtils.extractCleanSequences(this.textareaValueQuery.getText()).get(0);
        this.searchFileSequence.sequence = this.searchFileSequence.sequence.toUpperCase();
        this.isOk.setTrue();
        this.dispose();
    }

    private void fireActionCancel() {
        this.isOk.setFalse();
        this.dispose();
    }
}

