/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import ro.genomeartist.components.dropdownbutton.JDropDownButton;
import ro.genomeartist.components.glasspane.IDoScreenshot;
import ro.genomeartist.components.glasspane.JGlasspaneMessage;
import ro.genomeartist.gui.controller.exporters.MyImageFilter;
import ro.genomeartist.gui.controller.exporters.MyPdfFilter;
import ro.genomeartist.gui.controller.finalresult.FinalResultItem;
import ro.genomeartist.gui.icons.JToolbarFinalResultIcons;
import ro.genomeartist.gui.interfaces.IGlobalManager;
import ro.genomeartist.gui.interfaces.ILocalManager;
import ro.genomeartist.gui.mainpanels.finalresult.JFinalResultItemPane;
import ro.genomeartist.gui.utils.MyGlobalClasses;
import ro.genomeartist.gui.utils.MyUtils;

public class JFinalResultItemDialog
extends JDialog
implements IDoScreenshot {
    private static final int FRAME_WIDTH = 800;
    private static final int FRAME_HEIGHT = 600;
    private static final int BUTTON_WIDTH = 100;
    private static final String BUTTON_OK = "   Ok   ";
    private static final String ACTION_OK = "ok";
    private static final String ACTION_SET = "set";
    private IGlobalManager globalManager;
    private ILocalManager localManager;
    private FinalResultItem finalResultItem;
    private Container contentPane;
    private JLayeredPane layeredPane;
    private JGlasspaneMessage glassPane;
    private JToolBar toolbar;
    private JPanel middlePane;
    private JPanel bottomPane;
    private JButton buttonSet;
    private JButton buttonOk;
    JToolbarFinalResultIcons iconProvider;
    private static final String NAME_EXPORT = "Export";
    private static final String NAME_EXPORT_IMAGE = "as Image";
    private static final String NAME_EXPORT_PDF = "as Pdf";
    private static final String NAME_PRINT = "Print";
    private static final String NAME_BEST = "Best Result";
    private static final String ACTION_EXPORT = "Export".toLowerCase();
    private static final String ACTION_EXPORT_IMAGE = "as Image".toLowerCase();
    private static final String ACTION_EXPORT_PDF = "as Pdf".toLowerCase();
    private static final String ACTION_PRINT = "Print".toLowerCase();
    private static final String ACTION_BEST = "Best Result".toLowerCase();
    WindowListener windowListener = new WindowListener(){

        public void windowOpened(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
            if (!JFinalResultItemDialog.this.glassPane.isVisible()) {
                JFinalResultItemDialog.this.dispose();
            }
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowDeactivated(WindowEvent e) {
        }
    };
    ActionListener buttonListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (JFinalResultItemDialog.ACTION_OK.equals(cmd)) {
                JFinalResultItemDialog.this.fireActionOk();
            } else if (ACTION_EXPORT_IMAGE.equals(cmd)) {
                JFinalResultItemDialog.this.fireActionExportAsImage();
            } else if (ACTION_EXPORT_PDF.equals(cmd)) {
                JFinalResultItemDialog.this.fireActionExportAsPdf();
            } else if (ACTION_PRINT.equals(cmd)) {
                JFinalResultItemDialog.this.fireActionPrintResult();
            } else if (ACTION_BEST.equals(cmd)) {
                JFinalResultItemDialog.this.fireActionBestResult();
            }
        }
    };

    public JFinalResultItemDialog(IGlobalManager globalManager, ILocalManager localManager, String title, FinalResultItem finalResultItem) {
        super(globalManager.getTheRootFrame(), title, false);
        this.setSize(800, 600);
        this.setResizable(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this.windowListener);
        this.setLayout(new BorderLayout());
        this.layeredPane = this.getLayeredPane();
        this.contentPane = this.getContentPane();
        this.glassPane = new JGlasspaneMessage("Processing result", "(please wait)", (IDoScreenshot)this);
        this.setGlassPane((Component)this.glassPane);
        this.glassPane.setVisible(false);
        this.iconProvider = (JToolbarFinalResultIcons)MyGlobalClasses.get((String)"JToolbarFinalResultIcons");
        this.globalManager = globalManager;
        this.localManager = localManager;
        this.finalResultItem = finalResultItem;
        this.setResizable(true);
        this.setDefaultCloseOperation(1);
        this.setLayout(new BorderLayout());
        this.middlePane = new JFinalResultItemPane(globalManager, finalResultItem);
        this.add((Component)this.middlePane, "Center");
        this.toolbar = this.createToolBar();
        this.add((Component)this.toolbar, "North");
        this.bottomPane = new JPanel();
        this.bottomPane.setLayout(new BoxLayout(this.bottomPane, 0));
        this.bottomPane.add(Box.createHorizontalGlue());
        this.buttonOk = new JButton(BUTTON_OK);
        this.buttonOk.setActionCommand(ACTION_OK);
        this.buttonOk.addActionListener(this.buttonListener);
        this.bottomPane.add(this.buttonOk);
        this.bottomPane.add(Box.createHorizontalGlue());
        this.add((Component)this.bottomPane, "South");
        this.setLocationRelativeTo(globalManager.getTheRootFrame());
    }

    public JDropDownButton createButtonForExport() {
        JDropDownButton dropDownButton = null;
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem();
        menuItem.setText(NAME_EXPORT_IMAGE);
        menuItem.setActionCommand(ACTION_EXPORT_IMAGE);
        menuItem.addActionListener(this.buttonListener);
        menuItem.setIcon(this.iconProvider.getIcon(2));
        popupMenu.add(menuItem);
        menuItem = new JMenuItem();
        menuItem.setText(NAME_EXPORT_PDF);
        menuItem.setActionCommand(ACTION_EXPORT_PDF);
        menuItem.addActionListener(this.buttonListener);
        menuItem.setIcon(this.iconProvider.getIcon(3));
        popupMenu.add(menuItem);
        dropDownButton = new JDropDownButton(NAME_EXPORT, this.iconProvider.getIcon(1), popupMenu);
        return dropDownButton;
    }

    private JToolBar createToolBar() {
        JToolBar localToolBar = new JToolBar("Still draggable");
        JButton button = null;
        JDropDownButton dropButton = this.createButtonForExport();
        dropButton.setToolTipText("Export the result");
        localToolBar.add((Component)dropButton);
        button = new JButton(NAME_PRINT);
        button.setActionCommand(ACTION_PRINT);
        button.addActionListener(this.buttonListener);
        button.setToolTipText("Save a result");
        button.setIcon(this.iconProvider.getIcon(4));
        button.setFocusable(false);
        localToolBar.add(button);
        localToolBar.addSeparator();
        button = new JButton(NAME_BEST);
        button.setActionCommand(ACTION_BEST);
        button.addActionListener(this.buttonListener);
        button.setToolTipText("Load a result");
        button.setIcon(this.iconProvider.getIcon(5));
        button.setFocusable(false);
        localToolBar.add(button);
        localToolBar.setFocusable(false);
        localToolBar.setFloatable(false);
        localToolBar.setRollover(false);
        return localToolBar;
    }

    public BufferedImage takeScreenshot() {
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        this.layeredPane.paint(g2d);
        return image;
    }

    public void refresh() {
        this.layeredPane.revalidate();
    }

    public void turnOnGlasspane(boolean flag) {
        if (flag) {
            this.glassPane.showGlassPane();
        } else {
            this.glassPane.setVisible(false);
        }
    }

    public void fireActionOk() {
        this.dispose();
    }

    public void fireActionExportAsImage() {
        JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter(new MyImageFilter());
        fc.setAcceptAllFileFilterUsed(false);
        int returnVal = fc.showSaveDialog(this.globalManager.getTheRootFrame());
        if (returnVal == 0) {
            File selectedFile = fc.getSelectedFile();
            String basename = MyUtils.getBasename(selectedFile);
            basename = basename + ".png";
            final File destination = new File(basename);
            final FinalResultItem sourceResult = this.finalResultItem;
            this.turnOnGlasspane(true);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JFinalResultItemDialog.this.localManager.exportResultAsImage(sourceResult, destination);
                    JFinalResultItemDialog.this.turnOnGlasspane(false);
                }
            });
        }
    }

    public void fireActionExportAsPdf() {
        JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter(new MyPdfFilter());
        fc.setAcceptAllFileFilterUsed(false);
        int returnVal = fc.showSaveDialog(this.globalManager.getTheRootFrame());
        if (returnVal == 0) {
            File selectedFile = fc.getSelectedFile();
            String basename = MyUtils.getBasename(selectedFile);
            basename = basename + ".pdf";
            final File destination = new File(basename);
            FinalResultItem sourceResult = this.finalResultItem;
            this.turnOnGlasspane(true);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JFinalResultItemDialog.this.localManager.exportResultAsPdf(JFinalResultItemDialog.this.finalResultItem, destination);
                    JFinalResultItemDialog.this.turnOnGlasspane(false);
                }
            });
        }
    }

    public void fireActionPrintResult() {
        final FinalResultItem sourceResult = this.finalResultItem;
        this.turnOnGlasspane(true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JFinalResultItemDialog.this.localManager.printResult(sourceResult);
                JFinalResultItemDialog.this.turnOnGlasspane(false);
            }
        });
    }

    public void fireActionBestResult() {
        this.localManager.setBestResult(this.finalResultItem);
    }
}

