/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.mainpanels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import ro.genomeartist.gui.controller.exporters.FinalResultExporter;
import ro.genomeartist.gui.controller.finalresult.FinalResultItem;
import ro.genomeartist.gui.controller.query.MainResult;
import ro.genomeartist.gui.interfaces.IGlobalManager;
import ro.genomeartist.gui.interfaces.ILocalManager;
import ro.genomeartist.gui.mainpanels.JSideInfoPane;
import ro.genomeartist.gui.mainpanels.finalresult.JFinalResultSetPane;

public class JSearchResultPaneManager
extends JPanel
implements ILocalManager {
    private MainResult mainResult;
    private IGlobalManager globalManager;
    private static final double VALUE_PERCENTAGE = 0.34;
    private static final double VALUE_DISTRIBUTE = 0.1;
    private JSplitPane splitPane;
    private JSideInfoPane sideInfoPane;
    private JFinalResultSetPane finalResultSetPane;

    public JSearchResultPaneManager(IGlobalManager globalManager, MainResult mainResult) {
        this.mainResult = mainResult;
        this.globalManager = globalManager;
        this.setLayout(new BorderLayout());
        this.splitPane = new JSplitPane();
        this.sideInfoPane = new JSideInfoPane(globalManager, this, mainResult, mainResult.bestResult);
        this.finalResultSetPane = new JFinalResultSetPane(globalManager, this, mainResult.finalResultSet);
        this.splitPane.setLeftComponent(this.sideInfoPane);
        this.splitPane.setRightComponent(this.finalResultSetPane);
        this.splitPane.setDividerLocation(0.34);
        this.splitPane.setResizeWeight(0.1);
        this.add((Component)this.splitPane, "Center");
    }

    public MainResult getMainResult() {
        return this.mainResult;
    }

    public void setBestResult(FinalResultItem bestResult) {
        this.sideInfoPane.setBestResult(bestResult);
    }

    public void exportResultAsImage(FinalResultItem exportResult, File destination) {
        FinalResultExporter.exportResultAsImage(exportResult, destination);
    }

    public void exportResultAsPdf(FinalResultItem exportResult, File destination) {
        FinalResultExporter.exportResultAsPdf(this.globalManager, destination, this.mainResult, exportResult);
    }

    public void printResult(FinalResultItem exportResult) {
        FinalResultExporter.printReport(this.mainResult, exportResult);
    }
}

