/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.mainpanels.query;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import ro.genomeartist.gui.controller.query.InfoQuery;
import ro.genomeartist.gui.controller.query.MainResult;
import ro.genomeartist.gui.custompaint.DrawingConstants;
import ro.genomeartist.gui.dialogs.JPartialResultSetDialog;
import ro.genomeartist.gui.interfaces.IGlobalManager;
import ro.genomeartist.gui.interfaces.ILocalManager;
import ro.genomeartist.gui.popups.JTextareaPopup;
import ro.genomeartist.gui.utils.MyUtils;
import ro.genomeartist.gui.utils.StringUtils;

public class JInfoQueryPanel
extends JPanel {
    private InfoQuery infoQuery;
    private IGlobalManager globalManager;
    private ILocalManager localManager;
    private static final String TEXT_TITLE = "Query information";
    private static final String TEXT_DATE = "Search date";
    private static final String TEXT_TIME = "Time elapsed";
    private static final String TEXT_QUERY = "Query";
    private static final String TEXT_FINAL_RESULTS = "Final results";
    private static final String TEXT_PARTIAL_RESULTS = "Partial alignments";
    private static final String TEXT_OPEN = " Open partial alignments ";
    private static final String ACTION_OPEN = "open";
    private static final int TEXTAREA_ROWS = 3;
    private static final int TEXTAREA_COLS = 10;
    private static final int LABEL_SIZE = 50;
    JPanel datePane;
    JLabel labelTextDate;
    JLabel labelValueDate;
    JPanel timePane;
    JLabel labelTextTime;
    JLabel labelValueTime;
    JPanel queryHeaderPane;
    JLabel labelTextQueryHeader;
    JPanel queryPane;
    JTextArea textareaValueQuery;
    JPanel finalResultPane;
    JLabel labelTextFinalResults;
    JLabel labelValueFinalResults;
    JPanel partialResultPane;
    JLabel labelTextPartialResults;
    JLabel labelValuePartialResults;
    JPanel buttonPane;
    JButton openButton;
    ActionListener buttonListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (JInfoQueryPanel.ACTION_OPEN.equals(cmd)) {
                MainResult mainResult = JInfoQueryPanel.this.localManager.getMainResult();
                JPartialResultSetDialog dialog = new JPartialResultSetDialog(JInfoQueryPanel.this.globalManager, JInfoQueryPanel.TEXT_PARTIAL_RESULTS, true, mainResult.partialResultSet);
                dialog.setVisible(true);
            }
        }
    };

    public JInfoQueryPanel(IGlobalManager globalManager, ILocalManager localManager, InfoQuery infoQuery) {
        this.infoQuery = infoQuery;
        this.globalManager = globalManager;
        this.localManager = localManager;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createTitledBorder(TEXT_TITLE));
        this.labelTextDate = new JLabel(TEXT_DATE);
        MyUtils.setLabelBold(this.labelTextDate);
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        String auxString = dateFormat.format(infoQuery.searchDate);
        this.labelValueDate = new JLabel(auxString);
        MyUtils.setLabelBold(this.labelValueDate);
        this.datePane = this.createAlignedPane(this.labelTextDate, this.labelValueDate);
        this.add(this.datePane);
        this.labelTextTime = new JLabel(TEXT_TIME);
        MyUtils.setLabelBold(this.labelTextTime);
        auxString = StringUtils.timeToString(infoQuery.timpExecutie);
        this.labelValueTime = new JLabel(auxString);
        MyUtils.setLabelBold(this.labelValueTime);
        this.timePane = this.createAlignedPane(this.labelTextTime, this.labelValueTime);
        this.add(this.timePane);
        this.labelTextQueryHeader = new JLabel(TEXT_QUERY);
        MyUtils.setLabelBold(this.labelTextQueryHeader);
        this.labelTextQueryHeader.setPreferredSize(new Dimension(50, 0));
        this.queryHeaderPane = this.createAlignedPane(this.labelTextQueryHeader, new JLabel(" "));
        this.add(this.queryHeaderPane);
        this.textareaValueQuery = new JTextArea(3, 10);
        this.textareaValueQuery.setEditable(false);
        this.textareaValueQuery.setLineWrap(true);
        this.textareaValueQuery.setText(infoQuery.query);
        JTextareaPopup textareaPopup = new JTextareaPopup(this.textareaValueQuery, true);
        this.textareaValueQuery.addMouseListener(textareaPopup.getTextareaTrigger());
        JScrollPane scrollPane = new JScrollPane(this.textareaValueQuery);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setVerticalScrollBarPolicy(20);
        this.add(scrollPane);
        this.labelTextFinalResults = new JLabel(TEXT_FINAL_RESULTS);
        MyUtils.setLabelBold(this.labelTextFinalResults);
        this.labelValueFinalResults = new JLabel(infoQuery.finalResultNumber + "");
        MyUtils.setLabelBold(this.labelValueFinalResults);
        this.finalResultPane = this.createAlignedPane(this.labelTextFinalResults, this.labelValueFinalResults);
        this.add(this.finalResultPane);
        this.labelTextPartialResults = new JLabel(TEXT_PARTIAL_RESULTS);
        MyUtils.setLabelBold(this.labelTextPartialResults);
        this.labelValuePartialResults = new JLabel(infoQuery.partialResultNumber + "");
        MyUtils.setLabelBold(this.labelValuePartialResults);
        this.partialResultPane = this.createAlignedPane(this.labelTextPartialResults, this.labelValuePartialResults);
        this.add(this.partialResultPane);
        this.buttonPane = new JPanel();
        this.buttonPane.setLayout(new BoxLayout(this.buttonPane, 0));
        this.openButton = new JButton();
        this.openButton.setText(TEXT_OPEN);
        this.openButton.setActionCommand(ACTION_OPEN);
        this.openButton.addActionListener(this.buttonListener);
        this.buttonPane.add(Box.createHorizontalGlue());
        this.buttonPane.add(this.openButton);
        this.buttonPane.add(Box.createHorizontalGlue());
        this.add(this.buttonPane);
        this.add(Box.createVerticalGlue());
    }

    private JPanel createAlignedPane(JLabel label1, JLabel label2) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(label1);
        panel.add(Box.createHorizontalGlue());
        panel.add(label2);
        label2.setForeground(DrawingConstants.COLOR_GENOM_BORDER);
        return panel;
    }
}

