/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.popups;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTextArea;
import javax.swing.tree.DefaultMutableTreeNode;
import ro.genomeartist.gui.popups.JSimplePopup;

public class JTextareaPopup {
    private JTextArea textarea;
    boolean isReadonly;
    private DefaultMutableTreeNode selectedOferteTreeNode = null;
    private JSimplePopup textareaPopup;
    private static final String CUT = "Cut";
    private static final String COPY = "Copy";
    private static final String PASTE = "Paste";
    ActionListener textareaListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (JTextareaPopup.CUT.toLowerCase().equals(cmd)) {
                JTextareaPopup.this.textarea.cut();
            } else if (JTextareaPopup.COPY.toLowerCase().equals(cmd)) {
                JTextareaPopup.this.textarea.copy();
            } else if (JTextareaPopup.PASTE.toLowerCase().equals(cmd)) {
                JTextareaPopup.this.textarea.paste();
            }
        }
    };
    MouseListener textareaPopupTrigger = new MouseListener(){

        public void mouseClicked(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                if (JTextareaPopup.this.textarea.getSelectedText() != null) {
                    JTextareaPopup.this.textareaPopup.setItemEnabled(JTextareaPopup.CUT);
                    JTextareaPopup.this.textareaPopup.setItemEnabled(JTextareaPopup.COPY);
                    JTextareaPopup.this.textareaPopup.setItemEnabled(JTextareaPopup.PASTE);
                } else {
                    JTextareaPopup.this.textareaPopup.setItemDisabled(JTextareaPopup.CUT);
                    JTextareaPopup.this.textareaPopup.setItemDisabled(JTextareaPopup.COPY);
                    JTextareaPopup.this.textareaPopup.setItemEnabled(JTextareaPopup.PASTE);
                }
                if (JTextareaPopup.this.isReadonly) {
                    JTextareaPopup.this.textareaPopup.setItemDisabled(JTextareaPopup.CUT);
                    JTextareaPopup.this.textareaPopup.setItemDisabled(JTextareaPopup.PASTE);
                }
                JTextareaPopup.this.textareaPopup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    };

    public JTextareaPopup(JTextArea textarea, boolean isReadonly) {
        this.textarea = textarea;
        this.isReadonly = isReadonly;
        this.textareaPopup = this.createTextareaPopup();
    }

    public JTextareaPopup(JTextArea textarea) {
        this(textarea, false);
    }

    private JSimplePopup createTextareaPopup() {
        JSimplePopup popup = new JSimplePopup(this.textareaListener);
        popup.addItem(CUT);
        popup.addItem(COPY);
        popup.addItem(PASTE);
        return popup;
    }

    public MouseListener getTextareaTrigger() {
        return this.textareaPopupTrigger;
    }
}

