/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.reports.development;

import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import ro.genomeartist.gui.reports.development.SubGenesTestDataSource;
import ro.genomeartist.gui.reports.development.SubMappingTestDataSource;
import ro.genomeartist.gui.reports.development.SubPositioningTestDataSource;
import ro.genomeartist.gui.reports.development.SubQueryTestDataSource;
import ro.genomeartist.gui.reports.development.SubSmithWatermanTestDataSource;
import ro.genomeartist.gui.utils.ReadOnlyConfiguration;

public class ResultReportDataSource
implements JRDataSource {
    private Random rand = new Random(System.currentTimeMillis());
    private static final int LIMIT = 5;
    private int counter = 0;
    JRDataSource subreport_query_data;
    JasperReport subreport_query_engine;
    JRDataSource subreport_mapping_data;
    JasperReport subreport_mapping_engine;
    JRDataSource subreport_smith_data;
    JasperReport subreport_smith_engine;
    JRDataSource subreport_positioning_data;
    JasperReport subreport_positioning_engine;
    JRDataSource subreport_genes_data;
    JasperReport subreport_genes_engine;

    public ResultReportDataSource() {
        this.loadQueryReport();
        this.loadMappingReport();
        this.loadSmithReport();
        this.loadPositioningReport();
        this.loadGenesReport();
    }

    public void loadQueryReport() {
        String subreportFolder = ReadOnlyConfiguration.getString("JASPER_COMPILED_FOLDER");
        String subreportPath = subreportFolder + ReadOnlyConfiguration.getString("JASPER_COMPILED_SUB_QUERY");
        try {
            this.subreport_query_data = new SubQueryTestDataSource();
            this.subreport_query_engine = (JasperReport)JRLoader.loadObjectFromLocation((String)subreportPath);
        }
        catch (JRException ex) {
            Logger.getLogger(ResultReportDataSource.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void loadMappingReport() {
        String subreportFolder = ReadOnlyConfiguration.getString("JASPER_COMPILED_FOLDER");
        String subreportPath = subreportFolder + ReadOnlyConfiguration.getString("JASPER_COMPILED_SUB_MAPPING");
        try {
            this.subreport_mapping_data = new SubMappingTestDataSource();
            this.subreport_mapping_engine = (JasperReport)JRLoader.loadObjectFromLocation((String)subreportPath);
        }
        catch (JRException ex) {
            Logger.getLogger(ResultReportDataSource.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void loadSmithReport() {
        String subreportFolder = ReadOnlyConfiguration.getString("JASPER_COMPILED_FOLDER");
        String subreportPath = subreportFolder + ReadOnlyConfiguration.getString("JASPER_COMPILED_SUB_SMITH_WATERMAN");
        try {
            this.subreport_smith_data = new SubSmithWatermanTestDataSource();
            this.subreport_smith_engine = (JasperReport)JRLoader.loadObjectFromLocation((String)subreportPath);
        }
        catch (JRException ex) {
            Logger.getLogger(ResultReportDataSource.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void loadPositioningReport() {
        String subreportFolder = ReadOnlyConfiguration.getString("JASPER_COMPILED_FOLDER");
        String subreportPath = subreportFolder + ReadOnlyConfiguration.getString("JASPER_COMPILED_SUB_POSITIONING");
        try {
            this.subreport_positioning_data = new SubPositioningTestDataSource();
            this.subreport_positioning_engine = (JasperReport)JRLoader.loadObjectFromLocation((String)subreportPath);
        }
        catch (JRException ex) {
            Logger.getLogger(ResultReportDataSource.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void loadGenesReport() {
        String subreportFolder = ReadOnlyConfiguration.getString("JASPER_COMPILED_FOLDER");
        String subreportPath = subreportFolder + ReadOnlyConfiguration.getString("JASPER_COMPILED_SUB_GENES");
        try {
            this.subreport_genes_data = new SubGenesTestDataSource();
            this.subreport_genes_engine = (JasperReport)JRLoader.loadObjectFromLocation((String)subreportPath);
        }
        catch (JRException ex) {
            Logger.getLogger(ResultReportDataSource.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean next() throws JRException {
        if (this.counter < 5) {
            ++this.counter;
            return true;
        }
        return false;
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        String fieldName = jrField.getName();
        int scale = 2;
        switch (this.counter) {
            case 1: {
                if ("subreport_data".equals(fieldName)) {
                    return this.subreport_query_data;
                }
                if ("subreport_engine".equals(fieldName)) {
                    return this.subreport_query_engine;
                }
                throw new JRException("No field with specified name");
            }
            case 2: {
                if ("subreport_data".equals(fieldName)) {
                    return this.subreport_mapping_data;
                }
                if ("subreport_engine".equals(fieldName)) {
                    return this.subreport_mapping_engine;
                }
                throw new JRException("No field with specified name");
            }
            case 3: {
                if ("subreport_data".equals(fieldName)) {
                    return this.subreport_smith_data;
                }
                if ("subreport_engine".equals(fieldName)) {
                    return this.subreport_smith_engine;
                }
                throw new JRException("No field with specified name");
            }
            case 4: {
                if ("subreport_data".equals(fieldName)) {
                    return this.subreport_positioning_data;
                }
                if ("subreport_engine".equals(fieldName)) {
                    return this.subreport_positioning_engine;
                }
                throw new JRException("No field with specified name");
            }
            case 5: {
                if ("subreport_data".equals(fieldName)) {
                    return this.subreport_genes_data;
                }
                if ("subreport_engine".equals(fieldName)) {
                    return this.subreport_genes_engine;
                }
                throw new JRException("No field with specified name");
            }
        }
        return null;
    }
}

