/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.utils;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Random;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import ro.genomeartist.gui.RootFrame;
import ro.genomeartist.gui.utils.StringUtils;

public class MyUtils {
    public static final String TRANSPOSON_EXT = "ga";
    public static final String RAW_EXT = "raw";
    public static final String GENE_SUFFIX = "_gene.fasta";
    public static final String IMAGE_EXT = "png";
    public static final String PDF_EXT = "pdf";
    private static final int MINUTES_2_SECONDS = 60;
    private static final int HOURS_2_SECONDS = 3600;
    private static final Color LINK_COLOR = Color.blue;
    private static final Border LINK_BORDER = BorderFactory.createEmptyBorder(0, 0, 1, 0);
    private static final Border HOVER_BORDER = BorderFactory.createMatteBorder(0, 0, 1, 0, LINK_COLOR);

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static String getBasename(File f) {
        int min;
        String base = null;
        String s = f.getPath();
        int pos = s.lastIndexOf(46);
        if (pos <= (min = s.lastIndexOf(47)) || pos >= s.length() - 1) {
            return s;
        }
        base = s.substring(0, pos);
        return base;
    }

    public static String getFilenameNoExt(File f) {
        int min;
        String base = null;
        String s = f.getPath();
        int pos = s.lastIndexOf(46);
        if (pos <= (min = s.lastIndexOf(47)) || pos >= s.length() - 1) {
            return s;
        }
        base = s.substring(min + 1, pos);
        return base;
    }

    public static void setLabelBold(JLabel label) {
        Font oldFont = label.getFont();
        label.setFont(oldFont.deriveFont(1));
    }

    public static void increaseLabelFont(JLabel label, int offset) {
        Font oldFont = label.getFont();
        label.setFont(oldFont.deriveFont(oldFont.getStyle(), oldFont.getSize() + offset));
    }

    public static JButton createButton(String imageName, String actionCommand, String toolTipText, String altText, ActionListener listener) {
        URL imageURL = null;
        String imgLocation = null;
        if (imageName != null) {
            imgLocation = imageName;
            imageURL = RootFrame.class.getResource(imgLocation);
        }
        JButton button = new JButton();
        button.setActionCommand(actionCommand);
        button.setToolTipText(toolTipText);
        button.addActionListener(listener);
        if (imageURL != null) {
            button.setIcon(new ImageIcon(imageURL, altText));
            button.setText(altText);
        } else {
            button.setText(altText);
            if (imageName != null) {
                System.err.println("Resource not found: " + imgLocation);
            }
        }
        button.setFocusPainted(false);
        return button;
    }

    public static Image createImage(String imagePath) {
        BufferedImage result = null;
        URL imageURL = null;
        String imgLocation = null;
        if (imagePath != null) {
            imgLocation = imagePath;
            imageURL = RootFrame.class.getResource(imgLocation);
            if (imageURL != null) {
                try {
                    result = ImageIO.read(imageURL);
                }
                catch (IOException ex) {
                    System.err.println("IO error");
                }
            } else {
                System.err.println("File: " + imagePath + " not found !");
            }
        }
        return result;
    }

    public static JButton createLinkButton(String imageName, String actionCommand, String toolTipText, String altText, ActionListener listener) {
        JButton button = MyUtils.createButton(imageName, actionCommand, toolTipText, altText, listener);
        button.setBorder(LINK_BORDER);
        button.setForeground(LINK_COLOR);
        button.setCursor(Cursor.getPredefinedCursor(12));
        button.setFocusPainted(false);
        button.setRequestFocusEnabled(false);
        button.setContentAreaFilled(false);
        button.addMouseListener(new LinkMouseListener());
        return button;
    }

    public static void expandAll(JTree tree, boolean expand) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        MyUtils.expandAll(tree, new TreePath(root), expand);
    }

    private static void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                if (n.isLeaf()) continue;
                TreePath path = parent.pathByAddingChild(n);
                MyUtils.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public static String getRandomFileName() {
        String charset = "!0123456789abcdefghijklmnopqrstuvwxyz";
        Random rand = new Random(System.currentTimeMillis());
        int length = 10;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int pos = rand.nextInt(charset.length());
            sb.append(charset.charAt(pos));
        }
        String filename = sb.toString();
        filename = filename + ".ga";
        return filename;
    }

    public static int[] toPrimitive(Integer[] irri) {
        int[] array = new int[irri.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = irri[i];
        }
        return array;
    }

    public static void main(String[] args) {
        Pattern pattern = Pattern.compile("^@(\\w+)[\\s]*:[\\s]*([^:]*)");
        String searchString = "@info:test ytvv yvicv";
        String result = StringUtils.regexFind(pattern, searchString, 2);
        System.out.println(result);
    }

    private static class LinkMouseListener
    extends MouseAdapter {
        private LinkMouseListener() {
        }

        public void mouseEntered(MouseEvent e) {
            ((JComponent)e.getComponent()).setBorder(HOVER_BORDER);
        }

        public void mouseReleased(MouseEvent e) {
            ((JComponent)e.getComponent()).setBorder(LINK_BORDER);
        }

        public void mouseExited(MouseEvent e) {
            ((JComponent)e.getComponent()).setBorder(LINK_BORDER);
        }
    }
}

