/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.utils;

import java.io.File;
import java.util.Date;
import java.util.Random;
import ro.genomeartist.gui.controller.finalresult.FinalResultItem;
import ro.genomeartist.gui.controller.finalresult.FinalResultSet;
import ro.genomeartist.gui.controller.finalresult.IntervalMappingItem;
import ro.genomeartist.gui.controller.finalresult.IntervalMappingSet;
import ro.genomeartist.gui.controller.genes.GeneItem;
import ro.genomeartist.gui.controller.partialresult.PartialResultItem;
import ro.genomeartist.gui.controller.partialresult.PartialResultSet;
import ro.genomeartist.gui.controller.query.InfoQuery;
import ro.genomeartist.gui.controller.query.MainResult;
import ro.genomeartist.gui.controller.settings.AlgorithmParams;
import ro.genomeartist.gui.controller.settings.GeneralSettings;
import ro.genomeartist.gui.controller.settings.SearchFile;
import ro.genomeartist.gui.controller.settings.SearchFileSet;

public class TestData {
    private static final String charset = "!0123456789abcdefghijklmnopqrstuvwxyz";
    private static final String nucleotide = "ACGT-";
    private static final String relations = "| ";
    public static final int QUERY_LENGTH = 400;
    public static final int PARTIAL_RESULTS = 30;
    public static final int SEARCH_FILES = 30;
    public static final int FINAL_RESULTS = 20;
    public static final int GENOME_OFFSET = 10000;
    private static final int DATE_YEAR = 200;
    private static final int DATE_MONTH = 11;
    private static final int DATE_DAY = 20;
    private static Random rand = new Random(System.currentTimeMillis());

    public static GeneralSettings getTestGeneralSettings() {
        GeneralSettings generalSettings = new GeneralSettings();
        generalSettings.algorithmParams = TestData.getTestAlgorithmParams();
        generalSettings.genomFiles = TestData.getTestSearchFileSet(false);
        generalSettings.transposonFiles = TestData.getTestSearchFileSet(true);
        return generalSettings;
    }

    public static AlgorithmParams getTestAlgorithmParams() {
        AlgorithmParams algorithmParams = new AlgorithmParams();
        algorithmParams.setOffsetZero(rand.nextInt(30));
        algorithmParams.setScoreMatch(rand.nextInt(30));
        algorithmParams.setScoreMismatch(rand.nextInt(30));
        algorithmParams.setLengthModifier(rand.nextInt(30));
        algorithmParams.setPickingDepth(rand.nextInt(30));
        return algorithmParams;
    }

    public static SearchFileSet getTestSearchFileSet(boolean isTransposon) {
        int n = rand.nextInt(30);
        SearchFileSet searchFileSet = new SearchFileSet();
        for (int i = 0; i < n; ++i) {
            searchFileSet.add(TestData.getTestSearchFile(isTransposon));
        }
        return searchFileSet;
    }

    public static SearchFile getTestSearchFile(boolean isTransposon) {
        SearchFile searchFile = new SearchFile();
        searchFile.fileTitle = "Title_" + TestData.getRandomString(rand, 3);
        searchFile.rawLocation = new File("./resurse/" + TestData.getRandomString(rand, 3) + ".raw");
        searchFile.geneLocation = new File("./resurse/" + TestData.getRandomString(rand, 3) + ".gene");
        searchFile.isTransposon = isTransposon;
        return searchFile;
    }

    public static MainResult getTestMainResult() {
        MainResult mainResult = new MainResult();
        mainResult.infoQuery = TestData.getTestInfoQuery();
        mainResult.bestResult = TestData.getTestFinalResultItem();
        mainResult.finalResultSet = TestData.getTestFinalResultSet();
        mainResult.partialResultSet = TestData.getTestPartialResultSet();
        return mainResult;
    }

    public static InfoQuery getTestInfoQuery() {
        InfoQuery infoQuery = new InfoQuery();
        infoQuery.queryName = "Query_" + TestData.getRandomString(rand, 3);
        infoQuery.query = TestData.getRandomNucleotide(rand, 400);
        infoQuery.searchDate = new Date(rand.nextInt(200), rand.nextInt(11), rand.nextInt(20));
        infoQuery.timpExecutie = rand.nextInt(20);
        infoQuery.finalResultNumber = rand.nextInt(20);
        infoQuery.partialResultNumber = rand.nextInt(30);
        return infoQuery;
    }

    public static PartialResultSet getTestPartialResultSet() {
        int n = rand.nextInt(30);
        PartialResultSet partialResultSet = new PartialResultSet();
        for (int i = 0; i < n; ++i) {
            partialResultSet.add(TestData.getTestPartialResultItem());
        }
        return partialResultSet;
    }

    public static PartialResultItem getTestPartialResultItem() {
        PartialResultItem partialResultItem = new PartialResultItem();
        partialResultItem.setPozitieStartQuery(rand.nextInt(400));
        partialResultItem.setPozitieStartGenom(10000 + rand.nextInt(10000));
        partialResultItem.setLengthQuery(rand.nextInt(400 - partialResultItem.getPozitieStartQuery()));
        partialResultItem.setLengthGenom(rand.nextInt(400));
        partialResultItem.setLength(rand.nextInt(400));
        partialResultItem.setScore(rand.nextInt(400));
        partialResultItem.setOut1(TestData.getRandomNucleotide(rand, partialResultItem.getLength()));
        partialResultItem.setRelation(TestData.getRandomRelation(rand, partialResultItem.getLength()));
        partialResultItem.setOut2(TestData.getRandomNucleotide(rand, partialResultItem.getLength()));
        partialResultItem.setFisierOrigine("Arm_" + TestData.getRandomString(rand, 2));
        partialResultItem.setIsComplement(TestData.getRandomBoolean(rand));
        partialResultItem.setIsTransposon(TestData.getRandomBoolean(rand));
        partialResultItem.setLengthInitialQuery(400);
        return partialResultItem;
    }

    public static FinalResultSet getTestFinalResultSet() {
        FinalResultSet finalResultSet = new FinalResultSet();
        int n = rand.nextInt(20);
        for (int i = 0; i < n; ++i) {
            finalResultSet.add(TestData.getTestFinalResultItem());
        }
        return finalResultSet;
    }

    public static FinalResultItem getTestFinalResultItem() {
        FinalResultItem finalResultItem = new FinalResultItem();
        finalResultItem.setScore(rand.nextInt(400));
        finalResultItem.setLengthInitialQuery(400);
        int outTotalLength = finalResultItem.getOutTotalLength();
        finalResultItem.setOutTotalLength(400);
        finalResultItem.setOut1(TestData.getRandomNucleotide(rand, outTotalLength));
        finalResultItem.setRelation(TestData.getRandomRelation(rand, outTotalLength));
        finalResultItem.setOut2(TestData.getRandomNucleotide(rand, outTotalLength));
        finalResultItem.setIntervalMappingSet(TestData.getTestIntervalMappingSet(finalResultItem.getLengthInitialQuery(), finalResultItem.getOutTotalLength()));
        return finalResultItem;
    }

    public static IntervalMappingSet getTestIntervalMappingSet(int lengthInitialQuery, int outStringTotalLength) {
        IntervalMappingSet intervalMappingSet = new IntervalMappingSet();
        int x = 0;
        int y = 0;
        do {
            if ((y = (x = y) + rand.nextInt(lengthInitialQuery)) >= lengthInitialQuery) {
                y = lengthInitialQuery;
            }
            int length = y - x;
            IntervalMappingItem intervalMappingItem = TestData.getTestIntervalMappingItem(x, length, lengthInitialQuery, x, length, outStringTotalLength, intervalMappingSet);
            intervalMappingSet.add(intervalMappingItem);
        } while (y < lengthInitialQuery);
        return intervalMappingSet;
    }

    public static IntervalMappingItem getTestIntervalMappingItem(int offsetQuery, int lengthQuery, int lengthInitialQuery, int outStringOffset, int outStringLength, int outStringTotalLength, IntervalMappingSet mappingParinte) {
        IntervalMappingItem intervalMappingItem = new IntervalMappingItem(mappingParinte);
        intervalMappingItem.setFisierOrigine("Arm_" + TestData.getRandomString(rand, 2));
        intervalMappingItem.setPozitieQuery(offsetQuery);
        intervalMappingItem.setPozitieStartGenom(10000 + rand.nextInt(10000));
        intervalMappingItem.setLengthQuery(lengthQuery);
        intervalMappingItem.setLengthGenom(rand.nextInt(lengthInitialQuery));
        intervalMappingItem.setLengthInitialQuery(lengthInitialQuery);
        intervalMappingItem.setClosestUpstream(TestData.getTestGeneItem());
        intervalMappingItem.setClosestDownstream(TestData.getTestGeneItem());
        intervalMappingItem.addInsideGene(TestData.getTestGeneItem());
        intervalMappingItem.setOutStringOffset(outStringOffset);
        intervalMappingItem.setOutStringLength(outStringLength);
        intervalMappingItem.setOutStringTotalLength(outStringTotalLength);
        intervalMappingItem.setIsComplement(TestData.getRandomBoolean(rand));
        intervalMappingItem.setIsTransposon(TestData.getRandomBoolean(rand));
        return intervalMappingItem;
    }

    public static GeneItem getTestGeneItem() {
        GeneItem geneItem = new GeneItem();
        geneItem.setName("Gene_" + TestData.getRandomString(rand, 3));
        geneItem.setFisierOrigine("Arm_" + TestData.getRandomString(rand, 2));
        geneItem.setLocationStart(rand.nextInt(10000));
        geneItem.setLocationEnd(rand.nextInt(10000));
        geneItem.setIsComplement(TestData.getRandomBoolean(rand));
        geneItem.setCyto("Cyto-" + TestData.getRandomString(rand, 4));
        geneItem.setGeneId("FbID_" + TestData.getRandomString(rand, 4));
        return geneItem;
    }

    public static String getRandomString(Random rand, int length) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int pos = rand.nextInt(charset.length());
            sb.append(charset.charAt(pos));
        }
        return sb.toString();
    }

    public static String getRandomNucleotide(Random rand, int length) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int pos = rand.nextInt(nucleotide.length());
            sb.append(nucleotide.charAt(pos));
        }
        return sb.toString();
    }

    public static String getRandomRelation(Random rand, int length) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int pos = rand.nextInt(relations.length());
            sb.append(relations.charAt(pos));
        }
        return sb.toString();
    }

    public static boolean getRandomBoolean(Random rand) {
        int randint = rand.nextInt();
        return randint % 2 == 0;
    }
}

