/*
 * Decompiled with CFR 0.152.
 */
package testing.probability;

import java.math.BigDecimal;

public class EventVector {
    private int numberOfEvents;
    private double headProbability;
    private boolean[] eventVector;

    public EventVector(int numberOfEvents, double headProbability) {
        this.numberOfEvents = numberOfEvents;
        this.headProbability = headProbability;
        this.eventVector = new boolean[numberOfEvents];
        this.resetToStartEvent();
    }

    public int getNumberOfEvents() {
        return this.numberOfEvents;
    }

    public double getHeadProbability() {
        return this.headProbability;
    }

    public boolean getEventAt(int index) {
        if (index >= 0 && index < this.numberOfEvents) {
            return this.eventVector[index];
        }
        throw new ArrayIndexOutOfBoundsException(index + " >= " + this.numberOfEvents);
    }

    public void setHeadProbability(double headProbability) {
        this.headProbability = headProbability;
    }

    public void setEventAt(int index, boolean newValue) {
        if (index < 0 || index >= this.numberOfEvents) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.numberOfEvents);
        }
        this.eventVector[index] = newValue;
    }

    public BigDecimal computeVectorProbability() {
        BigDecimal result = BigDecimal.ONE;
        BigDecimal favorableProbability = new BigDecimal(this.headProbability);
        BigDecimal unfavorableProbability = new BigDecimal(1.0 - this.headProbability);
        for (int i = 0; i < this.eventVector.length; ++i) {
            result = this.eventVector[i] ? result.multiply(favorableProbability) : result.multiply(unfavorableProbability);
        }
        return result;
    }

    public void increment() {
        this.incrementEventAt(0);
    }

    private void resetToStartEvent() {
        for (int i = 0; i < this.eventVector.length; ++i) {
            this.eventVector[i] = false;
        }
    }

    private void incrementEventAt(int index) {
        boolean baseEvent = this.getEventAt(index);
        if (baseEvent) {
            this.setEventAt(index, false);
            if (index < this.getNumberOfEvents() - 1) {
                this.incrementEventAt(index + 1);
            } else {
                this.resetToStartEvent();
            }
        } else {
            this.setEventAt(index, true);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.eventVector.length; ++i) {
            if (this.eventVector[i]) {
                stringBuilder.append("1");
                continue;
            }
            stringBuilder.append("0");
        }
        return stringBuilder.toString();
    }
}

