/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.swingworkers.progressworker;

import exenne.components.dialogs.DialogFactory;
import exenne.components.modalpanel.progresspanel.JModalProgressPanel;
import exenne.components.swingworkers.IWorker;
import exenne.components.swingworkers.progressworker.AbstractProgressCallable;
import exenne.components.swingworkers.progressworker.ProgressInfoManager;
import exenne.components.utils.RandomDataGenerator;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JProgressSwingWorker<T>
extends SwingWorker<T, String>
implements IWorker,
ProgressInfoManager,
PropertyChangeListener {
    private final Frame rootFrame;
    protected JModalProgressPanel progressPanel;
    private boolean hasFinished;
    private int delay;
    private static int DEFAULT_DELAY = 500;
    protected AbstractProgressCallable<T> callableMethod;
    protected T result;
    private String standardError = null;

    public JProgressSwingWorker(Frame rootFrame, AbstractProgressCallable<T> callableMethod) {
        this(rootFrame, "", callableMethod);
    }

    public JProgressSwingWorker(Frame rootFrame, AbstractProgressCallable<T> callableMethod, int mode) {
        this(rootFrame, "", callableMethod, mode);
    }

    public JProgressSwingWorker(Frame rootFrame, String description, AbstractProgressCallable<T> callableMethod) {
        this(rootFrame, description, callableMethod, DEFAULT_DELAY, 0);
    }

    public JProgressSwingWorker(Frame rootFrame, String description, AbstractProgressCallable<T> callableMethod, int mode) {
        this(rootFrame, description, callableMethod, DEFAULT_DELAY, mode);
    }

    public JProgressSwingWorker(Frame rootFrame, String description, AbstractProgressCallable<T> callableMethod, int delay, int mode) {
        this.rootFrame = rootFrame;
        this.progressPanel = new JModalProgressPanel(rootFrame);
        this.callableMethod = callableMethod;
        callableMethod.setProgressInfoManager(this);
        this.addPropertyChangeListener(this);
        this.delay = delay;
        this.progressPanel.setDisplayMode(description, mode);
    }

    public void setDescription(String description) {
        this.progressPanel.setDisplayMode(description, 0);
    }

    public void setStandardErrorMessage(String errorMessage) {
        this.standardError = errorMessage;
    }

    public T executeTask() {
        this.hasFinished = false;
        this.execute();
        this.openProgressPanel();
        return this.result;
    }

    private void openProgressPanel() {
        try {
            Thread.sleep(this.delay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.hasFinished) {
            this.progressPanel.setVisible(true);
        }
        this.progressPanel.dispose();
    }

    @Override
    protected T doInBackground() throws Exception {
        return (T)this.callableMethod.call();
    }

    @Override
    public void setProgressValue(int value) {
        this.setProgress(value);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress".equals(evt.getPropertyName())) {
            int progress = (Integer)evt.getNewValue();
            this.progressPanel.setProgress(progress);
        }
    }

    @Override
    public void setProgressInfo(String info) {
        this.publish(info);
    }

    @Override
    protected void process(List<String> chunks) {
        String info = chunks.get(chunks.size() - 1);
        this.progressPanel.setText(info);
    }

    @Override
    protected void done() {
        try {
            this.hasFinished = true;
            this.result = this.get();
            this.closeProgressPanel();
        }
        catch (Exception ex) {
            this.hasFinished = true;
            this.result = null;
            ex.printStackTrace();
            this.closeProgressPanel();
            String error = this.standardError != null ? this.standardError : ex.getMessage();
            DialogFactory.showErrorDialog(this.rootFrame, "Eroare", error);
        }
    }

    private void closeProgressPanel() {
        this.progressPanel.setVisible(false);
    }

    public static void main(String[] args) {
        final JFrame frame = new JFrame("Test");
        frame.setDefaultCloseOperation(2);
        JButton button = new JButton("Do bg action");
        final AbstractProgressCallable<Integer> callable = new AbstractProgressCallable<Integer>(){

            @Override
            public Integer call() throws Exception {
                Integer integer = RandomDataGenerator.getRandomInt(10);
                int iterations = 20;
                for (int i = 0; i < iterations; ++i) {
                    this.setProgressInfo("ole_" + i);
                    int progress = (i + 1) * 100 / iterations;
                    this.setProgressValue(progress);
                    Thread.sleep(500L);
                }
                return integer;
            }
        };
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JProgressSwingWorker fillWorker = new JProgressSwingWorker(frame, "Computing", callable, 1);
                fillWorker.setStandardErrorMessage("Eroare la procesare formulare");
                Integer integer = (Integer)fillWorker.executeTask();
                System.out.println("Got result " + integer);
            }
        });
        frame.add(button);
        frame.pack();
        frame.setVisible(true);
    }
}

