/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.treetable.cellrenderers;

import exenne.components.treetable.cellrenderers.AbstractTreetableCellRenderer;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.border.Border;

public class ExpansionHandleBorder
implements Border {
    private Insets insets = new Insets(0, 0, 0, 0);

    public Insets getBorderInsets(Component c) {
        AbstractTreetableCellRenderer ren = (AbstractTreetableCellRenderer)c;
        if (ren.isShowHandle()) {
            this.insets.left = ren.getNestingDepth() == 0 ? 1 : ren.getExpansionHandleWidth() + (ren.getNestingDepth() - 1) * ren.getNestingWidth();
            this.insets.top = 0;
            this.insets.right = 5;
            this.insets.bottom = 0;
        } else {
            int halignment = ren.getHorizontalAlignment();
            if (halignment == 4) {
                this.insets.left = 0;
                this.insets.top = 0;
                this.insets.right = 5;
                this.insets.bottom = 0;
            } else {
                this.insets.left = 0;
                this.insets.top = 0;
                this.insets.right = 0;
                this.insets.bottom = 0;
            }
        }
        return this.insets;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        AbstractTreetableCellRenderer ren = (AbstractTreetableCellRenderer)c;
        if (ren.isShowHandle() && !ren.isLeaf()) {
            Icon icon = ren.isExpanded() ? ren.getExpandedIcon() : ren.getCollapsedIcon();
            int iconX = ren.getNestingDepth() == 0 ? 0 : (ren.getNestingDepth() - 1) * ren.getNestingWidth();
            int iconY = icon.getIconHeight() < height ? height / 2 - icon.getIconHeight() / 2 : 0;
            icon.paintIcon(c, g, iconX, iconY);
        }
    }
}

