/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.components.icons;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Random;
import javax.swing.Icon;

public class JColorIcon
implements Icon {
    private static Random rand = new Random(System.currentTimeMillis());
    private int width = 100;
    private int height = 16;
    private Color color;

    public JColorIcon() {
        this.setRandomColor();
    }

    public JColorIcon(Color color) {
        this.color = color;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setColor(this.color);
        g2d.fillRect(x, y, this.width, this.height);
        g2d.dispose();
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColorForText() {
        return JColorIcon.getColorForText(this.color);
    }

    public static Color getColorForText(Color bgColor) {
        int prag = 500;
        int current = bgColor.getRed() + bgColor.getGreen() + bgColor.getBlue();
        if (current < prag) {
            return Color.WHITE;
        }
        return Color.BLACK;
    }

    private void setRandomColor() {
        this.color = JColorIcon.getRandomColor();
    }

    public static Color getRandomColor() {
        float red = rand.nextFloat();
        float green = rand.nextFloat();
        float blue = rand.nextFloat();
        return new Color(red, green, blue);
    }
}

