/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.components.jtable.rowheader;

import java.awt.Color;
import java.util.Vector;
import ro.genomeartist.components.jtable.rowheader.RowAnnotation;

public class RowHeaderCellData {
    private String text;
    private Color backgroundColor;
    private Color foregroundColor;
    private RowAnnotation currentAnnotation;
    private int indexAnotatieCurenta;
    private Vector<RowAnnotation> rowAnnotations;

    public RowHeaderCellData() {
        this(null);
    }

    public RowHeaderCellData(String text) {
        this.text = text;
        this.backgroundColor = null;
        this.foregroundColor = null;
        this.currentAnnotation = null;
        this.indexAnotatieCurenta = -1;
        this.rowAnnotations = null;
    }

    public String getText() {
        return this.text;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public RowAnnotation getCurrentAnnotation() {
        return this.currentAnnotation;
    }

    public Vector<RowAnnotation> getRowAnnotations() {
        return this.rowAnnotations;
    }

    public int getRowAnnotationCount() {
        if (this.rowAnnotations != null) {
            return this.rowAnnotations.size();
        }
        return 0;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setForegroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public void setRowAnnotations(Vector<RowAnnotation> rowAnnotations) {
        this.rowAnnotations = rowAnnotations;
        if (rowAnnotations != null && !rowAnnotations.isEmpty()) {
            this.indexAnotatieCurenta = 0;
            this.currentAnnotation = rowAnnotations.elementAt(this.indexAnotatieCurenta);
        }
    }

    public boolean cycleAnnotations() {
        int count = this.getRowAnnotationCount();
        if (count > 1) {
            ++this.indexAnotatieCurenta;
            this.indexAnotatieCurenta %= count;
            this.currentAnnotation = this.rowAnnotations.elementAt(this.indexAnotatieCurenta);
            return true;
        }
        return false;
    }
}

