/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.components.propertiespanel.editors;

import java.awt.Color;
import java.awt.Dimension;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import ro.genomeartist.components.propertiespanel.IEditorChangeListener;
import ro.genomeartist.components.propertiespanel.IPropertiesEditor;
import ro.genomeartist.components.utils.StringUtilities;

public class JTextPanePropertiesEditor
extends JScrollPane
implements IPropertiesEditor,
DocumentListener {
    private JTextPane textpane = new JTextPane();
    private Vector<IEditorChangeListener> editorChangeListeners;

    public JTextPanePropertiesEditor(int width, int height) {
        super(20, 31);
        this.textpane.setPreferredSize(new Dimension(width, height));
        this.textpane.setMinimumSize(new Dimension(width, height));
        this.initialize();
    }

    public JTextPanePropertiesEditor() {
        super(20, 31);
        this.initialize();
    }

    private void initialize() {
        this.setViewportView(this.textpane);
        this.textpane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.textpane.setBackground(Color.WHITE);
        DefaultStyledDocument styleDocument = new DefaultStyledDocument();
        SimpleAttributeSet center = new SimpleAttributeSet();
        StyleConstants.setAlignment(center, 1);
        styleDocument.setParagraphAttributes(0, styleDocument.getLength(), center, false);
        this.textpane.setDocument(styleDocument);
        this.editorChangeListeners = new Vector();
        this.textpane.getDocument().addDocumentListener(this);
    }

    @Override
    public JComponent getContainerComponent() {
        return this;
    }

    @Override
    public JComponent getEditorComponent() {
        return this.textpane;
    }

    @Override
    public void setEditorName(String name) {
        this.textpane.setName(name);
    }

    @Override
    public void setValue(Class objectClass, Object renderedObject) {
        try {
            if (String.class != objectClass) {
                throw new UnsupportedOperationException(objectClass + " not supported in JTextArea");
            }
            String auxString = (String)renderedObject;
            DefaultStyledDocument styleDocument = new DefaultStyledDocument();
            AttributeSet attributeSet = this.textpane.getParagraphAttributes();
            styleDocument.insertString(0, auxString, null);
            styleDocument.setParagraphAttributes(0, styleDocument.getLength(), attributeSet, false);
            this.textpane.setDocument(styleDocument);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(JTextPanePropertiesEditor.class.getName()).log(Level.WARNING, "bad location", ex);
        }
    }

    @Override
    public Object getValue(Class objectClass) {
        if (String.class == objectClass) {
            String auxString = StringUtilities.removeWindowsCarriageReturn(this.textpane.getText());
            return auxString;
        }
        throw new UnsupportedOperationException(objectClass + " not supported in JTextArea");
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.notifyAllListeners();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.notifyAllListeners();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.notifyAllListeners();
    }

    private void notifyAllListeners() {
        for (IEditorChangeListener iEditorChangeListener : this.editorChangeListeners) {
            iEditorChangeListener.fireValueChanged();
        }
    }

    @Override
    public void addEditorChangeListener(IEditorChangeListener listener) {
        this.editorChangeListeners.add(listener);
    }

    @Override
    public void removeEditorChangeListener(IEditorChangeListener listener) {
        this.editorChangeListeners.remove(listener);
    }
}

