/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.components.swingworkers.progressworker;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import ro.genomeartist.components.swingworkers.progressworker.AbstractProgressCallable;
import ro.genomeartist.components.swingworkers.progressworker.JProgressSwingWorker;
import ro.genomeartist.components.utils.NumberUtils;
import ro.genomeartist.components.utils.RandomDataGenerator;

public class JProgressWorkerDeterminateTest {
    private static final AbstractProgressCallable<Integer> mainCallable = new AbstractProgressCallable<Integer>(){

        @Override
        public Integer call() throws Exception {
            Integer integer = RandomDataGenerator.getRandomInt(10);
            this.setProgressRange(0, 50);
            int iterations = 10;
            for (int i = 0; i < iterations; ++i) {
                this.setProgressInfo("main_" + i);
                int progress = (i + 1) * 100 / iterations;
                this.setProgressValue(progress);
                Thread.sleep(500L);
            }
            this.setProgressRange(50, 100);
            secondaryCallable.setProgressInfoManager(this);
            secondaryCallable.call();
            return integer;
        }
    };
    private static final AbstractProgressCallable<Integer> secondaryCallable = new AbstractProgressCallable<Integer>(){

        @Override
        public Integer call() throws Exception {
            Integer integer = RandomDataGenerator.getRandomInt(10);
            int i = 0;
            int iterations = 5;
            if (i < iterations) {
                this.setProgressInfo("secondary_" + i);
                int progress = (i + 1) * 100 / iterations;
                this.setProgressValue(progress);
                Thread.sleep(500L);
                this.addErrorMessage("dubious error");
                throw new Exception("ole");
            }
            return integer;
        }
    };

    public static void main(String[] args) {
        final JFrame frame = new JFrame("Test");
        frame.setDefaultCloseOperation(2);
        frame.setLocale(NumberUtils.LOCALE_RO);
        JButton button = new JButton("Do bg action");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JProgressSwingWorker fillWorker = new JProgressSwingWorker(frame, "Computing", mainCallable, 1);
                Integer integer = (Integer)fillWorker.executeTask();
                System.out.println("Got result " + integer);
            }
        });
        frame.add(button);
        frame.pack();
        frame.setVisible(true);
    }
}

