/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.components.transfer;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class TransferHandlerUtils {
    private static Object SandboxClipboardKey = new Object();

    public static boolean isCutEnabled(JComponent targetComponent) {
        TransferHandler transferHandler = targetComponent.getTransferHandler();
        if (transferHandler == null) {
            return false;
        }
        int sourceActions = transferHandler.getSourceActions(targetComponent);
        return sourceActions == 1 || sourceActions == 3 || sourceActions == 2;
    }

    public static boolean isCopyEnabled(JComponent targetComponent) {
        TransferHandler transferHandler = targetComponent.getTransferHandler();
        if (transferHandler == null) {
            return false;
        }
        int sourceActions = transferHandler.getSourceActions(targetComponent);
        return sourceActions == 1 || sourceActions == 3;
    }

    public static boolean isPasteEnabled(JComponent targetComponent) {
        Clipboard clipboard = TransferHandlerUtils.getClipboard(targetComponent);
        Transferable trans = null;
        if (clipboard != null) {
            trans = clipboard.getContents(null);
        }
        TransferHandler.TransferSupport transferSupport = new TransferHandler.TransferSupport((Component)targetComponent, trans);
        TransferHandler transferHandler = targetComponent.getTransferHandler();
        if (transferHandler != null && trans != null) {
            return targetComponent.getTransferHandler().canImport(transferSupport);
        }
        return false;
    }

    private static Clipboard getClipboard(JComponent c) {
        return Toolkit.getDefaultToolkit().getSystemClipboard();
    }
}

