/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.coloredtable;

import exenne.components.coloredtable.cellrenderers.AbstractColoredCellRenderer;
import exenne.components.coloredtable.cellrenderers.DefaultColoredCellRenderer;
import java.awt.Rectangle;
import java.math.BigDecimal;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

/**
 *
 * @author iulian
 */
public class JColoredTable extends JTable {
    public JColoredTable(AbstractColoredTableModel dm) {
        super(dm);
        AbstractColoredCellRenderer renderer = new DefaultColoredCellRenderer();
        setDefaultCellRenderer(renderer);
    }

    /**
     * Seteaza un cellrenderer default
     */
    public void setDefaultCellRenderer(AbstractColoredCellRenderer renderer) {
        setDefaultRenderer(Object.class,
                renderer);
        setDefaultRenderer(BigDecimal.class,
                renderer);
        setDefaultRenderer(Integer.class,
                renderer);
        setDefaultRenderer(String.class,
                renderer);
    }

    /**
     * Seteaza un cellrenderer default
     * @param columnClass
     * @param renderer
     */
    @Override
    public void setDefaultRenderer(Class<?> columnClass, TableCellRenderer renderer) {
        if (renderer instanceof AbstractColoredCellRenderer)
            super.setDefaultRenderer(columnClass, renderer);
        else return;
    }


    /**
     * Seteaza modelul din spate
     * @param dataModel
     */
    @Override
    public void setModel(TableModel dataModel) {
        if (dataModel instanceof AbstractColoredTableModel)
            super.setModel(dataModel);
        else return;
    }


    /**
     * Seteaza modelul din spate
     * @param dataModel
     */
    public void setModel(AbstractColoredTableModel dataModel) {
        super.setModel(dataModel);
    }

    /**
     * Obtine modelul din spate
     * @return
     */
    @Override
    public AbstractColoredTableModel getModel() {
        return (AbstractColoredTableModel) super.getModel();
    }

    /**
     * Selecteaza un rand
     */
    public void selectRow(int row) {
        int numberOfRows = this.getRowSorter().getViewRowCount();
        if (row >= 0 && row < numberOfRows) {
            this.addRowSelectionInterval(row, row);
        }
    }

    /**
     * Selecteaza si fa scroll la randul selectat
     * @param row
     */
    public void selectAndScrollToRow(int row) {
        int numberOfRows = this.getRowSorter().getViewRowCount();
        if (row >= 0 && row < numberOfRows) {
            this.addRowSelectionInterval(row, row);
            Rectangle rectangle = this.getCellRect(row, 0, true);
            this.scrollRectToVisible(rectangle);
        }
    }

}
