/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package exenne.components.sidebar;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import javax.swing.border.*;
import javax.swing.event.*;

/**
 *  <p style="margin-top: 0">
 *        Clasa ce construieste un JSideBar care ar trebui sa se auto-ascunda
 *          Sidebarul se poate adauga decat intr-un container de tip JSensitivePanel
 *      </p>
 * @author iulian
 */
public class JSideBar extends JPanel implements ActionListener {
    //Constante
    public static final int EAST_WEST = 0;
    public static final int WEST_EAST = 1;
    public static final int SOUTH_NORTH = 2;
    public static final int NORTH_SOUTH = 3;

    public static final int OPENED = 0;
    public static final int CLOSED = 1;
    public static final int INFINITE = 21000;
    
    //Variabile pentru dimensiunea containerului
    private int length;     //lungimea la care se va extinde totul
    private int draglength; //variabila pentru ajustarea dragului
    private int offsetSize;
    private int buttonSize; //Marimea butonului de retragere
    private int borderSize;

    //Variabile pentru starea containerului
    private int type;   //Tipul side-barului
    private int state;  //Starea in care se afla obiectul
    private boolean dragging;
    
    //Obiectele din interior
    private JButton button;
    private IResizableBorder border;
    private Border noborder;
    private JPanel sidebar; //this object
    private JSensitivePanel parent;

    //Managerul de icone
    JSideBarIcons iconProvider;

    /**
     *  <p style="margin-top: 0">
     *        Constructorul clasei. Initializeaza JSideBar-ul
     *      </p>
     * @author iulian
     * @param type Tipul sidebarului (stanga,dreapta sau jos)
     * @param state Starea sidebarului (deschis/inchis)
     */
    public JSideBar(int type, int state,int length, JSensitivePanel parent) {
        //Setez variabilele obiectului
        this.sidebar = this;
        this.parent = parent;

        //Variabile de dimensiune
        this.length = length;
        this.draglength = this.length;
        this.buttonSize = 24;
        this.borderSize = 6;
        this.offsetSize = 20;

        //Variabile de stare
        this.type = type;
        this.state = state;
        this.dragging = false;

        //Icon providerul
        iconProvider = new JSideBarIcons();
        
        //Setez parametrii Sidebarului
        setOpaque(false);
        setBackground(Color.blue);
        setLayout(new BorderLayout());

        //Adaug butonul de retragere
        button = new JButton();
        button.setActionCommand("unroll");
        button.setToolTipText("Deschide SideBarul");
        noborder = this.getBorder();

        //Modific proprietatiile dependente de tipul sidebarului
        Icon icon;
        switch (type) {
            case EAST_WEST:
                icon = iconProvider.getIcon(JSideBarIcons.LEFT);
                button.setIcon(icon);
                button.setPreferredSize(new Dimension(this.buttonSize, 0));
                this.setPreferredSize(new Dimension(this.buttonSize, 0));
                button.addActionListener(this);
                add(button, BorderLayout.WEST);
                border = new JResizableBorder(borderSize, IResizableBorder.WEST);
                break;
            case WEST_EAST:
                icon = iconProvider.getIcon(JSideBarIcons.RIGHT);
                button.setIcon(icon);
                button.setPreferredSize(new Dimension(this.buttonSize, 0));
                this.setPreferredSize(new Dimension(this.buttonSize, 0));
                button.addActionListener(this);
                add(button, BorderLayout.EAST);
                border = new JResizableBorder(borderSize, IResizableBorder.EAST);
                break;
            case SOUTH_NORTH:
                icon = iconProvider.getIcon(JSideBarIcons.UP);
                button.setIcon(icon);
                button.setPreferredSize(new Dimension(0, this.buttonSize));
                this.setPreferredSize(new Dimension(0, this.buttonSize));
                button.addActionListener(this);
                add(button, BorderLayout.NORTH);
                border = new JResizableBorder(borderSize, IResizableBorder.NORTH);
                break;
            case NORTH_SOUTH:
                icon = iconProvider.getIcon(JSideBarIcons.DOWN);
                button.setIcon(icon);
                button.setPreferredSize(new Dimension(0, this.buttonSize));
                this.setPreferredSize(new Dimension(0, this.buttonSize));
                button.addActionListener(this);
                add(button, BorderLayout.SOUTH);
                border = new JResizableBorder(borderSize, IResizableBorder.SOUTH);
                break;
            default:
                break;
        }

        if (this.state == JSideBar.OPENED) {
            unroll();
            setBorder(border);
        }
        //Adaug panoul cu componente
        JPanel aditional = new JPanel();
        aditional.setBackground(Color.RED);
        // aditional.setPreferredSize(new Dimension(100,10));
        add(aditional, BorderLayout.CENTER);
    }

    /**
     *  <p style="margin-top: 0">
     *        Constructorul clasei. Initializeaza JSideBar-ul
     *      </p>
     * @author iulian
     */
    public JSideBar(int type, JSensitivePanel parent) {
        this(type, JSideBar.CLOSED,200, parent);
    }


    /**
     * Adauga o componenta la Sidebar. Doar o singura componenta va fi vizibila. Pentru a adauga
     * mai multe componente se pun aceastea intr-un container
     * @param component Componenta ce trebuie adaugata
     * @author iulian
     */
    @Override
    public Component add(Component component)
    {
        super.add(component,BorderLayout.CENTER);
        return this;
    }

    /**
     *
     * @param length Lungimea extinsa a side-barului
     * @author iulian
     */
    public void setLength(int length) {
        int maximum = INFINITE;
        int rlength; //real length
        if (this.dragging == true) {
            this.draglength = length;
            if (length >= 0) {
                switch (type) {
                    case (EAST_WEST): case (WEST_EAST):
                        maximum = parent.getWidth();
                        break;
                    case (SOUTH_NORTH): case (NORTH_SOUTH):
                        maximum = parent.getHeight();
                        break;
                    default:
                        break;
                }
                maximum = (maximum/2) - buttonSize - borderSize - offsetSize;
                if (maximum < 0) maximum = 0;
                if (maximum < length) this.length = maximum;
                else this.length = length;
            }
        } else {
            switch (type) {
                case (EAST_WEST): case (WEST_EAST):
                    maximum = parent.getWidth();
                    break;
                case (SOUTH_NORTH): case (NORTH_SOUTH):
                    maximum = parent.getHeight();
                    break;
                default:
                    break;
            }
            maximum = (maximum/2) - buttonSize - borderSize - offsetSize;
            if (maximum < 0) maximum = 0;
            if (maximum < length) this.length = maximum;
            else this.length = length;
            this.draglength = length;
        }
    }

    /**
     * Notificare pentru resize
     */
    public void notifyResize() {
        setLength(this.length);
        if (this.state == OPENED) {
            unroll();
        }
    }

    /**
     *
     * Desface meniul
     * @author iulian
     */
    public void unroll() {
        int totalsize;
        this.state = JSideBar.OPENED;
        button.setActionCommand("roll");
        button.setToolTipText("Inchide SideBarul");
        totalsize = buttonSize + length + borderSize;
        Icon icon;
        switch (type) {
            case EAST_WEST:
                icon = iconProvider.getIcon(JSideBarIcons.RIGHT);
                button.setIcon(icon);
                setPreferredSize(new Dimension(totalsize, 0));
                break;
            case WEST_EAST:
                icon = iconProvider.getIcon(JSideBarIcons.LEFT);
                button.setIcon(icon);
                setPreferredSize(new Dimension(totalsize, 0));
                break;
            case SOUTH_NORTH:
                icon = iconProvider.getIcon(JSideBarIcons.DOWN);
                button.setIcon(icon);
                setPreferredSize(new Dimension(0, totalsize));
                break;
            case NORTH_SOUTH:
                icon = iconProvider.getIcon(JSideBarIcons.UP);
                button.setIcon(icon);
                setPreferredSize(new Dimension(0, totalsize));
                break;
            default:
                break;
        }
        setBorder(border);
    }

    /**
     *
     * Inchide meniul
     * @author iulian
     */
    public void roll() {
        this.state = JSideBar.CLOSED;
        button.setActionCommand("unroll");
        button.setToolTipText("Deschide SideBarul");
        Icon icon;
        switch (type) {
            case EAST_WEST:
                icon = iconProvider.getIcon(JSideBarIcons.LEFT);
                button.setIcon(icon);
                setPreferredSize(new Dimension(buttonSize, 0));
                break;
            case WEST_EAST:
                icon = iconProvider.getIcon(JSideBarIcons.RIGHT);
                button.setIcon(icon);
                setPreferredSize(new Dimension(buttonSize, 0));
                break;
            case SOUTH_NORTH:
                icon = iconProvider.getIcon(JSideBarIcons.UP);
                button.setIcon(icon);
                setPreferredSize(new Dimension(0, buttonSize));
                break;
            case NORTH_SOUTH:
                icon = iconProvider.getIcon(JSideBarIcons.DOWN);
                button.setIcon(icon);
                setPreferredSize(new Dimension(0, buttonSize));
                break;
            default:
                break;
        }
        setBorder(noborder);
    }

    /**
     * Toggle a SideBar between on or off
     */
    public void toggle() {
        if (this.state == CLOSED) unroll();
        else roll();
    }

    /**
     *  Metoda ce se executa la efectuarea unui click pe butonul de extindere
     * @param e
     * @author iulian
     */
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();

        //Daca Bara nu se misca atunci de vina este butonul de retragere
        if (cmd.equals("unroll")) { //Pornesc timerul de unroll
            unroll();
            revalidate();
        } else if (cmd.equals("roll")) { //Pornesc timerul de roll
            roll();
            revalidate();
        }
    }

    /**
     * Metoda este suprascrisa pentru a permite Folosirea ascultatorilor pe Border
     * @param border
     */
    @Override
    public void setBorder(Border border) {
        removeMouseListener(resizeListener);
        removeMouseMotionListener(resizeListener);
        if (border instanceof IResizableBorder) {
            addMouseListener(resizeListener);
            addMouseMotionListener(resizeListener);
        }
        super.setBorder(border);
    }

    /**
     * Metoda ce se apeleaza cand se termina operatiunea de resize
     */
    private void didResized() {
        int totalsize = buttonSize + length + borderSize;
        switch (type) {
            case EAST_WEST:
                setPreferredSize(new Dimension(totalsize, 0));
                break;
            case WEST_EAST:
                setPreferredSize(new Dimension(totalsize, 0));
                break;
            case SOUTH_NORTH:
                setPreferredSize(new Dimension(0, totalsize));
                break;
            case NORTH_SOUTH:
                setPreferredSize(new Dimension(0, totalsize));
                break;
            default:
                break;
        }
       revalidate();
    }

    //Ascultatorul pe border
    MouseInputListener resizeListener = new MouseInputAdapter() {

        @Override
        public void mouseMoved(MouseEvent me) {
            IResizableBorder border = (IResizableBorder) getBorder();
            setCursor(Cursor.getPredefinedCursor(border.getResizeCursor(me)));
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            setCursor(Cursor.getDefaultCursor());
        }
        private int cursor;
        private Point startPos = null;

        @Override
        public void mousePressed(MouseEvent me) {
            IResizableBorder border = (IResizableBorder) getBorder();
            cursor = border.getResizeCursor(me);
            startPos = me.getPoint();
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            Point aux;
            int totallength;
            JResizeMarker marker;
            if (startPos != null) {
                aux = sidebar.getLocation();
                int dx = me.getX() - startPos.x;
                int dy = me.getY() - startPos.y;
                dragging = true;
                switch (cursor) {
                    case Cursor.S_RESIZE_CURSOR:
                        startPos = me.getPoint();
                        setLength(draglength + dy);
                        totallength = aux.y + length + buttonSize+borderSize;
                        marker = new JResizeMarker(aux.x,totallength,sidebar.getWidth(),JResizeMarker.HORIZONTAL);
                        parent.setDrag(marker);
                        parent.repaint();
                        break;
                    case Cursor.N_RESIZE_CURSOR:
                        startPos = me.getPoint();
                        setLength(draglength - dy);
                        totallength = aux.y  + sidebar.getHeight() - length - buttonSize -borderSize;
                        marker = new JResizeMarker(aux.x,totallength,sidebar.getWidth(),JResizeMarker.HORIZONTAL);
                        parent.setDrag(marker);
                        parent.repaint();
                        break;
                    case Cursor.E_RESIZE_CURSOR:
                        startPos = me.getPoint();
                        setLength(draglength + dx);
                        totallength = aux.x + length + buttonSize+borderSize;
                        marker = new JResizeMarker(totallength,aux.y,sidebar.getHeight(),JResizeMarker.VERTICAL);
                        parent.setDrag(marker);
                        parent.repaint();
                        break;
                    case Cursor.W_RESIZE_CURSOR:
                        startPos = me.getPoint();
                        setLength(draglength - dx);
                        totallength = aux.x + sidebar.getWidth() - length - borderSize -buttonSize;
                        marker = new JResizeMarker(totallength,aux.y,sidebar.getHeight(),JResizeMarker.VERTICAL);
                        parent.setDrag(marker);
                        parent.repaint();
                        break;
                }

                // cursor shouldn't change while dragging
                setCursor(Cursor.getPredefinedCursor(cursor));
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            startPos = null;
            if (dragging) {
                dragging = false;
                draglength = length;
                parent.endDrag();
                didResized();
            }
        }
    };
}
