/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.treetable.undosupport;

import exenne.components.treetable.Treetable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

/**
 *
 * @author iulian
 */
public class MultiplePropertyStandardUndoableEdit extends AbstractUndoableEdit {
    //Eveniment de proprietati
    private ActionEvent someAction =
            new ActionEvent(this, 0, "MultiplePropertyStandardUndoableEdit");

    //Editarea unei valori in controller
    private Treetable treetable;
    private Vector<DefaultMutableTreeNode> targetNodes;
    private UndoableEdit controllerAction;
    private ActionListener actionListener;

    /**
     * Construieste o actiune de undo
     * @param targetNodes
     * @param controllerAction
     */
    public MultiplePropertyStandardUndoableEdit(Treetable treetable,
            Vector<DefaultMutableTreeNode> targetNodes,
            UndoableEdit controllerAction,
            ActionListener actionListener) {
        this.treetable = treetable;
        this.targetNodes = targetNodes;
        this.controllerAction = controllerAction;
        this.actionListener = actionListener;
    }

    /**
     * Operatia de undo
     * @throws CannotUndoException
     */
    @Override
    public void undo() throws CannotUndoException {
        super.undo();

        //1. Anulez actiunea din controller
        controllerAction.undo();

        //2. Fac selectia nodului care s-a modificat
        treetable.clearSelection();
        Iterator <DefaultMutableTreeNode> iterator = targetNodes.iterator();
        while (iterator.hasNext()) {
            DefaultMutableTreeNode targetNode = iterator.next();
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode) targetNode.getParent();
            if (parentNode != null) {
                treetable.expandNode(parentNode);
                treetable.selectAndScrollToNode(targetNode);
            }
        }

        //3. Notific modificarea pretului
        if (actionListener != null)
            actionListener.actionPerformed(someAction);
    }

    /**
     * Operatia de redo
     * @throws CannotRedoException
     */
    @Override
    public void redo() throws CannotRedoException {
        super.redo();

        //1. Refac acctiunea din controller
        controllerAction.redo();

        //2. Fac selectia nodului care s-a modificat
        treetable.clearSelection();
        Iterator <DefaultMutableTreeNode> iterator = targetNodes.iterator();
        while (iterator.hasNext()) {
            DefaultMutableTreeNode targetNode = iterator.next();
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode) targetNode.getParent();
            if (parentNode != null) {
                treetable.expandNode(parentNode);
                treetable.selectAndScrollToNode(targetNode);
            }
        }

        //3. Notific modificarea pretului
        if (actionListener != null)
            actionListener.actionPerformed(someAction);
    }
}