/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package exenne.components.comboactionbox;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

/**
 * Reprezinta o Actiune de ComboBox.
 * @author iulian
 */
public class ActionComboItem {
    private String name;
    private String actionName;
    private ActionListener actionListener;

    /**
     * Null action
     * @param name 
     */
    public ActionComboItem(String name) {
        this(name, null, null);
    }
    
    /**
     * Construiesc pachetul cu datele necesare lansarii unei actiuni
     * @param name
     * @param actionName
     * @param actionListener 
     */
    public ActionComboItem(String name, String actionName, 
            ActionListener actionListener) {
        this.name = name;
        this.actionName = actionName;
        this.actionListener = actionListener;
    }

    /**
     * Setez numele
     * @param name 
     */
    public void setName(String name) {
        this.name = name;
    }

    
    
    /**
     * Obtin numele
     * @return 
     */
    public String getName() {
        return name;
    }

    /**
     * Execut actiunea specificata de acest item
     */
    public void executeAction() {
        if (actionName != null && actionListener != null) {
            ActionEvent actionEvent = new ActionEvent(this, 0, actionName);
            actionListener.actionPerformed(actionEvent);
        }
    }
    
    /**
     * Implementez toString
     * @return 
     */
    @Override
    public String toString() {
        return name;
    }
}
