/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package exenne.components.dialogs;

import exenne.components.dialogs.JBooleanWrapper;
import exenne.components.dialogs.JBooleanWrapper;
import exenne.components.propertiespanel.AbstractPropertiesPanelModel;
import exenne.components.propertiespanel.IValidationProblemListener;
import exenne.components.propertiespanel.JPropertiesPanel;
import java.awt.Frame;
import org.netbeans.validation.api.Problem;
import org.netbeans.validation.api.Severity;

/**
 *
 * @author iulian
 */
public class JPropertiesContainerDialog extends JTwoButtonAbstractDialog 
    implements IValidationProblemListener {
    //Variabile de clasa
    JBooleanWrapper isOk;
    AbstractPropertiesPanelModel propertiesPanelModel;
    private boolean forceUpdate;
    
    //Structura panoului
    JPropertiesPanel propertiesPanel;
    
    public JPropertiesContainerDialog(Frame owner, String title, 
            boolean modal, AbstractPropertiesPanelModel propertiesPanelModel, JBooleanWrapper isOk) {
        super(owner, title, modal);
        
        //Variabilele de clasa
        this.isOk = isOk;
        this.propertiesPanelModel = propertiesPanelModel;
        this.forceUpdate = false;
        
        //Pun un panou de proprietati
        propertiesPanel = new JPropertiesPanel(propertiesPanelModel);
        propertiesPanel.addValidationProblemListener(this);

        //Setez panoul central
        this.setCenterComponent(propertiesPanel);

        this.pack();

        //Set it's location
        setLocationRelativeTo(owner);
    }
    
    /**
     * Forteaza updatarea obiectului la sfarsitul dialogului
     * @param forceUpdate
     */
    public void setForceUpdate(boolean forceUpdate) {
        this.forceUpdate = forceUpdate;
    }
    
     /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *      Actiunile asupra Dialogului
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * A aparut o pleblema de validare
     * @param problem
     */
    public void validationProblemChanged(Problem problem) {
        boolean enable = problem == null ? true : problem.severity() != Severity.FATAL;
        this.setEnableOk(enable);
    }

    /**
     * Lansez actiunea OK
     */
    public void fireActionOk() {
        boolean hasChanged = forceUpdate;

        //Fac commit la date
        hasChanged = propertiesPanel.commitChanges() || hasChanged;
        if (hasChanged) {
            dispose();
            isOk.setTrue();
        } else {
            dispose();
            isOk.setFalse();
        }
    }

    /**
     * Lansez actiunea de anulare
     */
    public void fireActionCancel() {
        //inchid dialogul
        dispose();
        isOk.setFalse();
    }
    
}
