/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package exenne.components.icons;

import exenne.components.utils.ComponentsUtils;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

/**
 * Clasa are singurul scop sa incarce si sa pastreze informatii despre icon
 * @author iulian
 */
public class IconDelegate {
    private BufferedImage image;
    private Icon icon;

    /**
     * Construiesc imaginea unui icon
     * @param path 
     */
    public IconDelegate(String path) {
        image = ComponentsUtils.loadImage(path);
        if (image != null) {
            icon =  new ImageIcon(image);
        } else {
            icon = JNoIcon.ICON16;
        }
    }
    
    
    /**
     * Obtine imaginea ce sta la baza iconului
     * @return 
     */
    public BufferedImage getImage() {
        return image;
    }
    
    /**
     * Obtin iconul reprezentat de delegat
     * @return 
     */
    public Icon getIcon() {
        return icon;
    }
}
