/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package exenne.components.miscellaneous.labellines;

import exenne.components.utils.ComponentsUtils;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

/**
 * Clasa ce reprezinta un titlu de sectiune
 * @author iulian
 */
public class JTitleLine extends JPanel {
    private JLabel titleLabel;
    
    /**
     * Contructor secundar
     * @param title
     */
    public JTitleLine(String title) {
        this(title, null, null, 0, 0, false);
    }
    
    /**
     * Contructor secundar
     * @param title
     */
    public JTitleLine(String title, boolean makeBold) {
        this(title, null, null, 0, 0, makeBold);
    }
    
    /**
     * Contructor secundar
     * @param title
     * @param bgColor 
     */
    public JTitleLine(String title, Color bgColor) {
        this(title, null, bgColor, 0, 0, false);
    }
    
    /**
     * Contructor secundar.
     * @param title
     * @param bgColor
     * @param makeBold 
     */
    public JTitleLine(String title, Color bgColor, boolean makeBold) {
        this(title, null, bgColor, 0, 0, makeBold);
    }
    
    /**
     * Contructor secundar.
     * @param title
     * @param icon
     * @param bgColor 
     */
    public JTitleLine(String title, Icon icon, Color bgColor) {
        this(title, icon, bgColor, 0, 0, false);
    }
    
    
    /**
     * Contructorul principal. Construiesc un panou de titlu
     * @param title     Titlul ce se afiseaza
     * @param icon      Iconul pentru titlu
     * @param bgColor   Culoarea titlului
     * @param hspacer   Marginea din stanga si din dreapta
     */
    public JTitleLine(String title, Icon icon, Color bgColor, int hspacer, int vspacer, boolean makeBold) {
        super();
        
        //Configurez panoul
        this.setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
            Border outerBorder = BorderFactory.createEmptyBorder(vspacer, hspacer, 0, hspacer);
            Border innerBorder = BorderFactory.createMatteBorder(0, 0, 1, 0, Color.DARK_GRAY);
        this.setBorder(BorderFactory.createCompoundBorder(outerBorder, innerBorder));
        
        //Culoare de bg
        this.setBackground(bgColor);
        this.setOpaque(true);
        
        //Pun titlul
        titleLabel = new JLabel();
            titleLabel.setText(title);
            titleLabel.setIcon(icon);
            titleLabel.setOpaque(false);
        this.add(titleLabel);
        
        //Daca fac bold
        if (makeBold)
            ComponentsUtils.setFontBold(titleLabel);
        
        //Spacer
        this.add(Box.createHorizontalGlue());
    }
    
    
}
