/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package exenne.components.passwordfield.fixedwidth;

import exenne.components.popup.CopyPastePopupManager;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import javax.swing.JPasswordField;

/**
 *
 * @author iulian
 */
public class JFixedWidthPasswordField extends JPasswordField {
    
    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *    Constructori
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    
    /**
     * Constructor secundar null
     */
    public JFixedWidthPasswordField() {
        this(0);
    }     
    
    /**
     * Constructor secundar
     * Constructor ce primeste ca parametru dimensiunea la care sa se ajunga
     * @param width dimensiunea celulei
     */
    public JFixedWidthPasswordField(int width) {
        this("",width);
    }    
    
    /**
     * Constructorul principal
     * Constructor ce primeste ca parametru dimensiunea la care sa se ajunga
     * @param text Textul ce se va afisa in textfield
     * @param width dimensiunea celulei
     */
    public JFixedWidthPasswordField(String text,int width) {
        super(text);
        configureFixedWidth(width);
        
        //Activez popup pentru copy-paste
        setCopyPastePopupEnabled(true);
    }

    
    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *    Metode publice
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    
    /**
     * Seteaza dimesiunea acestui textfield
     * @param width 
     */
    public void setFixedWidth(int width) {
        configureFixedWidth(width);
    }
    
    /**
     * Activeaza sau dezactiveaza popup-ul de copy-paste
     * @param isEnabled 
     */
    public void setCopyPastePopupEnabled(boolean shouldEnable) {
        MouseListener popupTrigger = CopyPastePopupManager.getCopyPastePopup().getPopupTrigger();
        
        //Activez sau dezactivez popup-ul
        this.removeMouseListener(popupTrigger);
        if (shouldEnable) {
            this.addMouseListener(popupTrigger);
        }
    }
    
    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *    Metode private
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    /**
     * Seteaza dimesiunea acestui textfield
     * @param width 
     */
    private void configureFixedWidth(int width) {
        if (width > 0) {
            int columnWidth = this.getColumnWidth();
            this.setColumns(width / columnWidth);
           // this.setPreferredSize(new Dimension(width, width));
            this.setMaximumSize(new Dimension(width, width));
        }
    }
}
